/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.diagram;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.junit.Assert;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.ThreatSourceUse;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.test.diagram.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DragAndDropFromProjectExplorerTool;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.kitalpha.emde.model.EmdePackage;

public class ThreatDiagram
extends DiagramContext {
    public ThreatDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public DNode createThreat() {
        return (DNode)new CreateNodeTool((DiagramContext)this, "ToolCreateThreat", this.getDiagramId()).run();
    }

    public DNode createFunctionalPrimaryAsset() {
        return (DNode)new CreateNodeTool((DiagramContext)this, "ToolCreateFunctionalPrimaryAsset", this.getDiagramId()).run();
    }

    public DDiagramElementContainer createOperationalEntity() {
        return (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, "operational.entity", this.getDiagramId()).run();
    }

    public DNode createOperationalActor() {
        return (DNode)new CreateNodeTool((DiagramContext)this, "ToolCreateOperationalActor", this.getDiagramId()).run();
    }

    public DNode createActor() {
        return (DNode)new CreateNodeTool((DiagramContext)this, "ToolCreateActor", this.getDiagramId()).run();
    }

    protected void setThreatSource(CapellaElement actor) {
        TrustBoundaryStorage storage = CybersecurityFactory.eINSTANCE.createTrustBoundaryStorage();
        storage.setThreatSource(true);
        actor.getOwnedExtensions().add((Object)storage);
    }

    public DNode createInformationPrimaryAsset() {
        return (DNode)new CreateNodeTool((DiagramContext)this, "ToolCreateInformationPrimaryAsset", this.getDiagramId()).run();
    }

    public DNode createEnterprisePrimaryAsset() {
        return (DNode)new CreateNodeTool((DiagramContext)this, "ToolCreateEnterprisePrimaryAsset", this.getDiagramId()).run();
    }

    public DEdge createThreatInvolvement(DNode threat, DNode actor) {
        return (DEdge)new CreateDEdgeTool(this, "ToolCreateThreatInvolvement", threat.getUid(), actor.getUid()).run();
    }

    public DEdge createThreatApplication(DNode threat, DNode asset) {
        return (DEdge)new CreateDEdgeTool(this, "ToolCreateThreatApplication", threat.getUid(), asset.getUid()).run();
    }

    public DEdge createThreatSourceUse(DNode threatSource, DNode actor) {
        return (DEdge)new ThreatDiagramCreateDEdgeTool(this, "ToolCreateThreatuse", threatSource.getUid(), actor.getUid()).run();
    }

    public void dndThreat(DiagramContext diagram, EObject threat) {
        new DragAndDropFromProjectExplorerTool(diagram, "D&D Threat From Project Explorer", threat, diagram.getDiagramId()).run();
    }

    public void dndInformationPrimaryAsset(DiagramContext diagram, EObject pa) {
        new DragAndDropFromProjectExplorerTool(diagram, "D&D Information Primary Asset From Project Explorer", pa, diagram.getDiagramId()).run();
    }

    public void dndFunctionalPrimaryAsset(DiagramContext diagram, EObject pa) {
        new DragAndDropFromProjectExplorerTool(diagram, "D&D Functional Primary Asset From Project Explorer", pa, diagram.getDiagramId()).run();
    }

    public void dndEnterprisePrimaryAsset(DiagramContext diagram, EObject pa) {
        new DragAndDropFromProjectExplorerTool(diagram, "D&D Enterprise Primary Asset From Project Explorer", pa, diagram.getDiagramId()).run();
    }

    public static ThreatDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        return (ThreatDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, "Threat Diagram"){

            public DiagramContext getResult() {
                return new ThreatDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static class ThreatDiagramCreateDEdgeTool
    extends CreateDEdgeTool {
        public ThreatDiagramCreateDEdgeTool(DiagramContext context, String toolName, String sourceView, String targetView) {
            super(context, toolName, sourceView, targetView);
        }

        @Override
        public DEdge getResult() {
            return null;
        }

        @Override
        protected void postRunTest() {
            EObject threatSource = this.getDiagramContext().getView(this._sourceView).getTarget();
            ThreatSourceUse use = ((Collection)threatSource.eGet((EStructuralFeature)EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS)).stream().filter(ThreatSourceUse.class::isInstance).findFirst().orElse(null);
            Assert.assertNotNull((Object)use);
            Assert.assertEquals((Object)use.getUsed(), (Object)this.getDiagramContext().getView(this._targetView).getTarget());
        }
    }
}

