/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ocl.requester.view.actions;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.ocl.requester.OCLRequesterPlugin;
import org.polarsys.capella.ocl.requester.internal.l10n.OCLInterpreterMessages;
import org.polarsys.capella.ocl.requester.view.actions.OCLInterpreterViewAction;

public class ImportOCLTextAction
extends OCLInterpreterViewAction {
    private final String tip = OCLInterpreterMessages.OCLInterpreterView_importOCLTextAction_tip;

    public ImportOCLTextAction() {
        super(OCLInterpreterMessages.OCLInterpreterView_importOCLTextAction_label, OCLRequesterPlugin.getImageDescriptor("icons/elcl16/oclimport.gif"));
    }

    public String getToolTipText() {
        return this.tip;
    }

    @Override
    public void run() {
        super.run();
        Shell shell = this.view.getPage().getShell();
        String oclExpression = null;
        try {
            oclExpression = this.view.getDocument().get(0, this.view.getDocument().getLength());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        boolean confirm = true;
        if (oclExpression != null) {
            confirm = MessageDialog.openConfirm((Shell)shell, (String)OCLInterpreterMessages.OCLInterpreterView_importOCLTextWarn_title, (String)OCLInterpreterMessages.OCLInterpreterView_importOCLTextWarn_noExpr);
        }
        if (confirm) {
            FileDialog dlg = new FileDialog(shell, 4096);
            dlg.setFilterExtensions(new String[]{"*.ocl"});
            dlg.setText(OCLInterpreterMessages.OCLInterpreterView_importOCLTextDlg_title);
            String file = dlg.open();
            if (file != null) {
                try {
                    String line;
                    FileReader reader = new FileReader(file);
                    BufferedReader buffer = new BufferedReader(reader);
                    oclExpression = "";
                    while ((line = buffer.readLine()) != null) {
                        oclExpression = String.valueOf(oclExpression) + line;
                        oclExpression = String.valueOf(oclExpression) + System.getProperty("line.separator");
                    }
                    reader.close();
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)shell, (String)OCLInterpreterMessages.OCLInterpreterView_importOCLTextError_title, (String)e.getLocalizedMessage());
                }
                if (!oclExpression.isEmpty()) {
                    this.view.getDocument().set(oclExpression);
                }
            }
        }
    }
}

