/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ocl.requester.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.ocl.requester.OCLRequesterPlugin;
import org.polarsys.capella.ocl.requester.console.IOCLFactory;
import org.polarsys.capella.ocl.requester.console.text.ColorManager;
import org.polarsys.capella.ocl.requester.console.text.OCLDocument;
import org.polarsys.capella.ocl.requester.console.text.OCLSourceViewer;
import org.polarsys.capella.ocl.requester.internal.l10n.OCLInterpreterMessages;
import org.polarsys.capella.ocl.requester.level.ModelingLevel;
import org.polarsys.capella.ocl.requester.patterns.EcoreOCLFactory;
import org.polarsys.capella.ocl.requester.view.VariableContentProvider;
import org.polarsys.capella.ocl.requester.view.actions.ClearOutputAction;
import org.polarsys.capella.ocl.requester.view.actions.DropDownAction;
import org.polarsys.capella.ocl.requester.view.actions.EcoreMetamodelAction;
import org.polarsys.capella.ocl.requester.view.actions.ExportOCLTextAction;
import org.polarsys.capella.ocl.requester.view.actions.ExportResultAction;
import org.polarsys.capella.ocl.requester.view.actions.HistoryBackAction;
import org.polarsys.capella.ocl.requester.view.actions.HistoryForwardAction;
import org.polarsys.capella.ocl.requester.view.actions.ImportOCLTextAction;
import org.polarsys.capella.ocl.requester.view.actions.ModelingLevelAction;
import org.polarsys.capella.ocl.requester.view.actions.OCLEvaluateAction;
import org.polarsys.capella.ocl.requester.view.provider.TupleItemProviderAdapterFactory;

public class OCLInterpreterView
extends ViewPart {
    private static int BUNDLE_AVAILABLE = 44;
    public static final String ID = "org.polarsys.capella.ocl.requester.view.OCLInterpreterID";
    private Composite page;
    private TreeViewer treeViewer;
    private ITextViewer output;
    protected OCLSourceViewer input;
    protected OCLDocument document;
    private ColorManager colorManager;
    private String lastOCLExpression;
    protected EObject context;
    private ISelectionService selectionService;
    private ISelectionListener selectionListener;
    private IOCLFactory<Object> oclFactory;
    private OCL<?, Object, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> ocl;
    private ModelingLevel modelingLevel = ModelingLevel.M2Simplified;
    private static final AdapterFactory reflectiveAdapterFactory = new ReflectiveItemProviderAdapterFactory();
    private static final AdapterFactory defaultAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private ITreeContentProvider contentProvider;
    private Label contextName;
    private Label errorOutput;
    private ILabelProvider labelProvider;
    private DropDownAction metamodelAction = new DropDownAction();
    private DropDownAction levelAction = new DropDownAction();
    private boolean evaluationSuccess = false;
    private List<String> history = new ArrayList<String>();
    private int currentHistoryPointer = 0;
    public IItemLabelProvider tupleTypeLabelProvider = new IItemLabelProvider(){

        public Object getImage(Object object) {
            return null;
        }

        public String getText(Object object) {
            Tuple tuple = (Tuple)object;
            TupleType tupleType = tuple.getTupleType();
            StringBuffer result = new StringBuffer();
            Iterator iter = tupleType.oclProperties().iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                result.append(OCLInterpreterView.this.toString(tuple.getValue(next)));
                if (!iter.hasNext()) continue;
                result.append(",");
            }
            return result.toString();
        }
    };

    public void createPartControl(Composite parent) {
        this.page = new SashForm(parent, 0x2000200);
        this.page.setFont(JFaceResources.getHeaderFont());
        this.colorManager = new ColorManager();
        this.document = new OCLDocument();
        this.document.setModelingLevel(this.modelingLevel);
        this.contextName = new Label(this.page, 0);
        this.errorOutput = new Label(this.page, 0);
        this.errorOutput.setForeground(this.colorManager.getColor(ColorManager.OUTPUT_ERROR));
        this.input = new OCLSourceViewer(this.page, this.colorManager, 2050);
        this.input.setDocument((IDocument)this.document);
        this.input.getTextWidget().addKeyListener((KeyListener)new InputKeyListener());
        this.input.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        CTabFolder tabFolder = new CTabFolder(this.page, 2048);
        tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        CTabItem tabItem1 = new CTabItem(tabFolder, 0);
        tabItem1.setText(OCLInterpreterMessages.OCLInterpreterView_tbtmModelOutput_text);
        Composite composite = new Composite((Composite)tabFolder, 0);
        tabItem1.setControl((Control)composite);
        composite.setLayout((Layout)new TreeColumnLayout());
        ComposedAdapterFactory adapterFactory = (ComposedAdapterFactory)SiriusEditPlugin.getPlugin().getItemProvidersAdapterFactory();
        adapterFactory.insertAdapterFactory((AdapterFactory)new TupleItemProviderAdapterFactory());
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        this.treeViewer = new TreeViewer(composite, 2050);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        CTabItem tabItem2 = new CTabItem(tabFolder, 0);
        tabItem2.setText("Console Output");
        this.output = new TextViewer((Composite)tabFolder, 2818);
        StyledText styledTextOutput = this.output.getTextWidget();
        tabItem2.setControl((Control)styledTextOutput);
        this.output.getTextWidget().setLayoutData((Object)new GridData(1808));
        this.output.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.output.setEditable(false);
        this.output.setDocument((IDocument)new Document());
        tabFolder.setSelection(0);
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                OCLInterpreterView.this.selectionChanged(selection);
            }
        };
        this.selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionService.addPostSelectionListener(this.selectionListener);
        ISelection selection = this.selectionService.getSelection();
        if (selection == null) {
            selection = this.getActiveSelection();
        }
        this.selectionChanged(selection);
        ((SashForm)this.page).setWeights(new int[]{1, 1, 5, 8});
        this.createActions();
    }

    public void createActions() {
        OCLEvaluateAction evaluate = new OCLEvaluateAction();
        evaluate.setView(this);
        HistoryBackAction historyBack = new HistoryBackAction();
        historyBack.setView(this);
        HistoryForwardAction historyForward = new HistoryForwardAction();
        historyForward.setView(this);
        ClearOutputAction clear = new ClearOutputAction(this.output);
        clear.setView(this);
        ExportOCLTextAction exportOCLText = new ExportOCLTextAction();
        exportOCLText.setView(this);
        ImportOCLTextAction importOCLText = new ImportOCLTextAction();
        importOCLText.setView(this);
        ExportResultAction exportResult = new ExportResultAction();
        exportResult.setView(this);
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        menu.add((IAction)evaluate);
        menu.add((IAction)historyForward);
        menu.add((IAction)historyBack);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)importOCLText);
        menu.add((IAction)exportOCLText);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)exportResult);
        menu.add((IAction)clear);
        menu.add((IContributionItem)new Separator());
        MenuManager metamodelMenu = new MenuManager(OCLInterpreterMessages.console_metamodelMenu, "org.polarsys.capella.ocl.requester.metamodel");
        menu.add((IContributionItem)metamodelMenu);
        this.metamodelAction.setToolTipText(OCLInterpreterMessages.console_metamodelTip);
        this.setMetamodelAction((IMenuManager)metamodelMenu);
        MenuManager levelMenu = new MenuManager(OCLInterpreterMessages.console_modelingLevel);
        menu.add((IContributionItem)levelMenu);
        this.levelAction.setToolTipText(OCLInterpreterMessages.console_modelingLevelTip);
        ModelingLevelAction m2s = new ModelingLevelAction(ModelingLevel.M2Simplified);
        m2s.setView(this);
        m2s.setChecked(true);
        levelMenu.add((IAction)m2s);
        this.levelAction.addAction((IAction)m2s);
        ModelingLevelAction m2 = new ModelingLevelAction(ModelingLevel.M2);
        m2.setView(this);
        levelMenu.add((IAction)m2);
        this.levelAction.addAction((IAction)m2);
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)evaluate);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)historyBack);
        toolbar.add((IAction)historyForward);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.levelAction);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)importOCLText);
        toolbar.add((IAction)exportOCLText);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)exportResult);
        toolbar.add((IAction)clear);
    }

    ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new VariableContentProvider(SiriusEditPlugin.getPlugin().getItemProvidersAdapterFactory());
        }
        return this.contentProvider;
    }

    public void setFocus() {
    }

    boolean evaluate(String expression) {
        boolean result = true;
        if (this.context == null) {
            result = false;
            this.error(OCLInterpreterMessages.console_noContext);
        } else {
            if (this.oclFactory == null) {
                this.oclFactory = new EcoreOCLFactory(this.context);
            }
            this.ocl = this.oclFactory.createOCL(this.modelingLevel);
            OCLHelper helper = this.ocl.createOCLHelper();
            try {
                ConstraintKind kind = this.modelingLevel.setContext(helper, this.context, this.oclFactory);
                IDocument doc = this.getOutputDocument();
                Color outputDefault = this.colorManager.getColor(ColorManager.DEFAULT);
                Color outputResults = this.colorManager.getColor(ColorManager.OUTPUT_RESULTS);
                if (doc.getLength() > 0) {
                    this.append("", outputDefault, false);
                }
                this.append(OCLInterpreterMessages.console_evaluating, outputDefault, true);
                this.append(expression, outputDefault, false);
                this.append(OCLInterpreterMessages.console_results, outputDefault, true);
                switch (this.modelingLevel) {
                    case M2: 
                    case M2Simplified: {
                        OCLExpression parsed = helper.createQuery(expression);
                        Object r = this.ocl.evaluate((Object)this.context, parsed);
                        this.handleExpressionResult(r);
                        this.print(r, outputResults, false);
                        break;
                    }
                    case M1: {
                        helper.createConstraint(kind, expression);
                        this.print(OCLInterpreterMessages.console_parsed, outputResults, false);
                    }
                }
                this.errorOutput.setText("");
                this.lastOCLExpression = expression;
            }
            catch (Exception e) {
                result = false;
                this.error(e.getLocalizedMessage() == null ? e.getClass().getName() : e.getLocalizedMessage());
            }
        }
        return result;
    }

    public void evaluate() {
        String text = this.document.get();
        this.evaluationSuccess = this.evaluate(text.trim());
    }

    public void historyBack() {
        if (this.currentHistoryPointer == 0 && this.history.size() > 0) {
            if (this.history.size() > 0 && this.history.get(0).length() == 0) {
                this.history.remove(0);
            }
            this.history.add(0, this.document.get().trim());
            this.currentHistoryPointer = 1;
            this.setTextFromHistory();
        } else if (this.currentHistoryPointer < this.history.size() - 1) {
            ++this.currentHistoryPointer;
            this.setTextFromHistory();
        }
    }

    public void historyForward() {
        if (this.currentHistoryPointer > 0) {
            --this.currentHistoryPointer;
            this.setTextFromHistory();
        }
    }

    public void historyClean() {
        if (this.evaluationSuccess) {
            this.document.set("");
            if (this.history.size() > 0 && this.history.get(0).trim().length() == 0) {
                this.history.remove(0);
            }
            if (this.history.size() == 0 || !this.history.get(0).equals(this.lastOCLExpression.trim())) {
                this.history.add(0, this.lastOCLExpression.trim());
            }
            this.currentHistoryPointer = 0;
        }
        this.evaluationSuccess = false;
    }

    public void showPossibleCompletions() {
        this.input.getContentAssistant().showPossibleCompletions();
    }

    protected void setTextFromHistory() {
        String newText = this.history.get(this.currentHistoryPointer);
        this.document.set(newText);
        this.input.setSelectedRange(newText.length(), 0);
    }

    public IDocument getOutputDocument() {
        return this.output.getDocument();
    }

    private void print(Object object, Color color, boolean bold) {
        Collection<Object> toPrint = object == null ? Collections.EMPTY_SET : (object instanceof Collection ? (Collection)object : (object.getClass().isArray() ? Arrays.asList((Object[])object) : Collections.singleton(object)));
        for (Object e : toPrint) {
            this.append(this.toString(e), color, bold);
        }
        this.scrollText();
    }

    public String toString(Object object) {
        if (this.ocl != null && this.ocl.isInvalid(object)) {
            return "OclInvalid";
        }
        if (object instanceof String) {
            return "'" + object + "'";
        }
        if (object instanceof Tuple) {
            return this.tupleTypeLabelProvider.getText(object);
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            IItemLabelProvider labeler = (IItemLabelProvider)defaultAdapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
            if (labeler == null) {
                labeler = (IItemLabelProvider)reflectiveAdapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
            }
            if (labeler != null) {
                return labeler.getText(object);
            }
        }
        return String.valueOf(object);
    }

    private void error(String message) {
        this.errorOutput.setText(message);
        this.append(message, this.colorManager.getColor(ColorManager.OUTPUT_ERROR), false);
        this.scrollText();
    }

    private void scrollText() {
        this.output.revealRange(this.getOutputDocument().getLength(), 0);
    }

    private void append(String text, Color color, boolean bold) {
        IDocument doc = this.getOutputDocument();
        try {
            int offset = doc.getLength();
            int length = text.length();
            text = String.valueOf(text) + '\n';
            if (offset > 0) {
                doc.replace(offset, 0, text);
            } else {
                doc.set(text);
            }
            StyleRange style = new StyleRange();
            style.start = offset;
            style.length = length;
            style.foreground = color;
            if (bold) {
                style.fontStyle = 1;
            }
            this.output.getTextWidget().setStyleRange(style);
        }
        catch (BadLocationException e) {
            Status status = new Status(4, OCLRequesterPlugin.getPluginId(), 1, OCLInterpreterMessages.console_outputExc, (Throwable)e);
            OCLRequesterPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private ISelection getActiveSelection() {
        ISelectionProvider selectionProvider;
        block13: {
            IEditorSite editorSite;
            block12: {
                IEditorPart activeEditor;
                block11: {
                    IWorkbenchPage activePage;
                    block10: {
                        IWorkbenchWindow workbenchWindow;
                        block9: {
                            IWorkbenchPartSite site;
                            block8: {
                                try {
                                    site = this.getSite();
                                    if (site != null) break block8;
                                    return null;
                                }
                                catch (Exception e) {
                                    return null;
                                }
                            }
                            workbenchWindow = site.getWorkbenchWindow();
                            if (workbenchWindow != null) break block9;
                            return null;
                        }
                        activePage = workbenchWindow.getActivePage();
                        if (activePage != null) break block10;
                        return null;
                    }
                    activeEditor = activePage.getActiveEditor();
                    if (activeEditor != null) break block11;
                    return null;
                }
                editorSite = activeEditor.getEditorSite();
                if (editorSite != null) break block12;
                return null;
            }
            selectionProvider = editorSite.getSelectionProvider();
            if (selectionProvider != null) break block13;
            return null;
        }
        return selectionProvider.getSelection();
    }

    private void selectionChanged(ISelection sel) {
        IStructuredSelection ssel;
        if (sel instanceof IStructuredSelection && !(ssel = (IStructuredSelection)sel).isEmpty()) {
            Object selected = ssel.getFirstElement();
            this.context = CapellaAdapterHelper.resolveSemanticObject((Object)selected);
            this.document.setOCLContext(this.context);
            if (!this.contextName.isDisposed()) {
                this.contextName.setText(this.toString(this.context));
            }
            this.levelAction.run();
            this.metamodelAction.run();
        }
    }

    private Integer handleExpressionResult(Object result) {
        if (result != null) {
            ArrayList<Object> input;
            if (result instanceof Collection) {
                input = (ArrayList<Object>)result;
            } else {
                input = new ArrayList<Object>(1);
                input.add(result);
            }
            this.treeViewer.setInput(input);
            return input.size();
        }
        this.treeViewer.setInput(null);
        return 0;
    }

    private void setMetamodelAction(IMenuManager metamodelMenu) {
        EcoreMetamodelAction ecore = new EcoreMetamodelAction();
        ecore.setView(this);
        ecore.setChecked(true);
        ecore.run();
        ImageDescriptor img = this.getImage((EObject)EcoreFactory.eINSTANCE.getEPackage());
        if (img != null) {
            ecore.setImageDescriptor(img);
        }
        metamodelMenu.add((IAction)ecore);
        this.metamodelAction.addAction((IAction)ecore);
    }

    static boolean isAvailable(Bundle bundle) {
        return (bundle.getState() & BUNDLE_AVAILABLE) != 0;
    }

    private ImageDescriptor getImage(EObject element) {
        Object image;
        ImageDescriptor result = null;
        IItemLabelProvider provider = (IItemLabelProvider)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE).adapt((Notifier)element, IItemLabelProvider.class);
        if (provider != null && (image = provider.getImage((Object)element)) != null) {
            result = ExtendedImageRegistry.INSTANCE.getImageDescriptor(image);
        }
        return result;
    }

    public Composite getPage() {
        return this.page;
    }

    public String getLastOCLExpression() {
        return this.lastOCLExpression;
    }

    public ModelingLevel getModelingLevel() {
        return this.modelingLevel;
    }

    public void setModelingLevel(ModelingLevel modelingLevel) {
        this.modelingLevel = modelingLevel;
    }

    public OCLDocument getDocument() {
        return this.document;
    }

    public void setDocument(OCLDocument document) {
        this.document = document;
    }

    public IOCLFactory<Object> getOclFactory() {
        return this.oclFactory;
    }

    public void setOclFactory(IOCLFactory<Object> oclFactory) {
        this.oclFactory = oclFactory;
    }

    public EObject getContext() {
        return this.context;
    }

    public TreeItem[] getTreeItem() {
        return this.treeViewer.getTree().getItems();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private class InputKeyListener
    implements KeyListener {
        private InputKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if (OCLInterpreterView.this.input.isContentAssistActive() || (e.stateMask & 0x60000) != 0) break;
                    OCLInterpreterView.this.evaluate();
                    break;
                }
                case 0x1000005: {
                    if (OCLInterpreterView.this.input.isContentAssistActive() || (e.stateMask & 0x60000) != 0) break;
                    OCLInterpreterView.this.historyBack();
                    break;
                }
                case 0x1000006: {
                    if (OCLInterpreterView.this.input.isContentAssistActive() || (e.stateMask & 0x60000) != 0) break;
                    OCLInterpreterView.this.historyForward();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if ((e.stateMask & 0x40000) != 0) break;
                    OCLInterpreterView.this.historyClean();
                    break;
                }
                case 32: {
                    if ((e.stateMask & 0x40000) != 262144) break;
                    OCLInterpreterView.this.showPossibleCompletions();
                }
            }
        }
    }
}

