/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ocl.requester.patterns.templates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.CollectionUtil;
import org.polarsys.capella.ocl.requester.patterns.templates.CustomOperation;
import org.polarsys.capella.ocl.requester.patterns.templates.OperationSignature;

public class PatternEnvironmentFactory
extends EcoreEnvironmentFactory {
    protected final Map<OperationSignature, CustomOperation> _additionalOperations = new HashMap<OperationSignature, CustomOperation>();
    protected OCLStandardLibrary<EClassifier> library;

    public PatternEnvironmentFactory() {
        OCL result = OCL.newInstance();
        this.library = result.getEnvironment().getOCLStandardLibrary();
    }

    public PatternEnvironmentFactory(EPackage.Registry reg) {
        super(reg);
        OCL result = OCL.newInstance();
        this.library = result.getEnvironment().getOCLStandardLibrary();
    }

    private void addCustomOperations(EcoreEnvironment env) {
        EClassifier everyElement = (EClassifier)env.getOCLStandardLibrary().getOclAny();
        OCLStandardLibrary lib = env.getOCLStandardLibrary();
        this.registerCustomOperation(env, new CustomOperation(everyElement, "oclOwner", everyElement, false){

            @Override
            public Object executeOn(Object source, List<Object> args) {
                return ((EObject)source).eContainer();
            }
        });
        this.registerCustomOperation(env, new CustomOperation(everyElement, "oclOwners", everyElement, true){

            @Override
            public Object executeOn(Object source, List<Object> args) {
                ArrayList<EObject> result = new ArrayList<EObject>();
                EObject current = ((EObject)source).eContainer();
                while (current != null) {
                    result.add(current);
                    current = current.eContainer();
                }
                return result;
            }
        });
        this.registerCustomOperation(env, new CustomOperation(everyElement, "oclChildren", everyElement, true){

            @Override
            public Object executeOn(Object source, List<Object> args) {
                return ((EObject)source).eContents();
            }
        });
        this.registerCustomOperation(env, new CustomOperation(everyElement, "oclAllChildren", everyElement, true){

            @Override
            public Object executeOn(Object source, List<Object> args) {
                ArrayList<EObject> result = new ArrayList<EObject>();
                TreeIterator it = ((EObject)source).eAllContents();
                while (it.hasNext()) {
                    result.add((EObject)it.next());
                }
                return result;
            }
        });
        this.registerCustomOperation(env, new CustomOperation(everyElement, "oclIsLeaf", (EClassifier)lib.getBoolean(), false){

            @Override
            public Object executeOn(Object source, List<Object> args) {
                boolean result = ((EObject)source).eContents().isEmpty();
                return result;
            }
        });
        this.registerCustomOperation(env, new CustomOperation(everyElement, "oclIsRoot", (EClassifier)lib.getBoolean(), false){

            @Override
            public Object executeOn(Object source, List<Object> args) {
                boolean result = ((EObject)source).eContainer() == null;
                return result;
            }
        });
        this.registerCustomOperation(env, new CustomOperation(everyElement, "oclTypeName", (EClassifier)lib.getString(), false){

            @Override
            public Object executeOn(Object source, List<Object> args) {
                EClass type = ((EObject)source).eClass();
                EPackage epackage = type.getEPackage();
                return String.valueOf(epackage.getName()) + "::" + type.getName();
            }
        });
    }

    public EcoreEnvironment createEnvironment() {
        EcoreEnvironment result = (EcoreEnvironment)super.createEnvironment();
        this.addCustomOperations(result);
        return result;
    }

    public ExtendedEcoreEvaluationEnvironment createEvaluationEnvironment() {
        return new ExtendedEcoreEvaluationEnvironment();
    }

    public ExtendedEcoreEvaluationEnvironment createEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
        return new ExtendedEcoreEvaluationEnvironment(parent);
    }

    private void registerCustomOperation(EcoreEnvironment env, CustomOperation customOperation) {
        customOperation.defineIn(env);
        this._additionalOperations.put(customOperation.getSignature(), customOperation);
    }

    private class ExtendedEcoreEvaluationEnvironment
    extends EcoreEvaluationEnvironment {
        public ExtendedEcoreEvaluationEnvironment() {
        }

        public ExtendedEcoreEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
            super(parent);
        }

        public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
            Object result = null;
            OperationSignature signature = new OperationSignature(operation);
            CustomOperation customOperation = PatternEnvironmentFactory.this._additionalOperations.get(signature);
            if (customOperation != null) {
                result = customOperation.executeOn(source, Arrays.asList(args));
            }
            result = result != null ? this.coerceValue((ETypedElement)operation, result, false) : super.callOperation(operation, opcode, source, args);
            return result;
        }

        public Object coerceValue(ETypedElement element, Object value, boolean copy) {
            CollectionKind kind = ExtendedEcoreEvaluationEnvironment.getCollectionKind((ETypedElement)element);
            if (kind != null) {
                if (value instanceof Collection) {
                    return copy ? CollectionUtil.createNewCollection((CollectionKind)kind, (Collection)((Collection)value)) : value;
                }
                Collection result = CollectionUtil.createNewCollection((CollectionKind)kind);
                result.add(value);
                return result;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return collection.isEmpty() ? null : collection.iterator().next();
            }
            return value;
        }
    }
}

