/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ocl.requester.decorators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;

public abstract class AbstractDecorator
implements ILabelDecorator {
    protected Map<String, ComposedImage> composedImagesCache = new HashMap<String, ComposedImage>(0);

    public void addListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image initialImage, Object element) {
        Image result = null;
        EObject eObject = null;
        if (element instanceof IAdaptable) {
            eObject = (EObject)((IAdaptable)element).getAdapter(EObject.class);
        } else if (element instanceof EObject) {
            eObject = (EObject)element;
        }
        ArrayList<String> suffixes = new ArrayList<String>(0);
        Image imageLock = this.doDecorateImage(eObject, element, suffixes);
        if (imageLock != null) {
            Couple<List<Object>, List<ComposedImage.Point>> imageStructures = this.getImageStructures(eObject, initialImage);
            List images = (List)imageStructures.getKey();
            images.add(imageLock);
            List positions = (List)imageStructures.getValue();
            positions.add(this.getOverlayPosition().point);
            result = this.getComposedImage(this.getImageKey(eObject, suffixes), images, positions);
        }
        return result;
    }

    protected abstract Image doDecorateImage(EObject var1, Object var2, List<String> var3);

    public String decorateText(String initialText, Object element) {
        String result = null;
        EObject eObject = null;
        if (element instanceof IAdaptable) {
            eObject = (EObject)((IAdaptable)element).getAdapter(EObject.class);
        } else if (element instanceof EObject) {
            eObject = (EObject)element;
        }
        result = this.doDecorateText(initialText, element, eObject);
        return result;
    }

    protected abstract String doDecorateText(String var1, Object var2, EObject var3);

    protected OverlayPosition getOverlayPosition() {
        return OverlayPosition.SE;
    }

    public void dispose() {
    }

    protected Image getComposedImage(String key, List<Object> images, final List<ComposedImage.Point> positions) {
        ComposedImage result = this.composedImagesCache.get(key);
        if (result == null) {
            result = new ComposedImage(images){

                public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
                    return positions;
                }
            };
            this.composedImagesCache.put(key, result);
        }
        return ExtendedImageRegistry.getInstance().getImage((Object)result);
    }

    protected String getImageKey(EObject object, List<String> suffixes) {
        StringBuilder builder = new StringBuilder(object.eClass().getName());
        for (String string : suffixes) {
            if (string == null) continue;
            builder.append('_').append(string);
        }
        return builder.toString();
    }

    private Couple<List<Object>, List<ComposedImage.Point>> getImageStructures(EObject object, Image initialImage) {
        ArrayList<Image> images = new ArrayList<Image>(1);
        images.add(initialImage);
        ArrayList<ComposedImage.Point> positions = new ArrayList<ComposedImage.Point>(1);
        positions.add(OverlayPosition.NW.point);
        return new Couple(images, positions);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected static enum OverlayPosition {
        NE(9, 0),
        NW(0, 0),
        SE(9, 9),
        SO(0, 9);

        protected final ComposedImage.Point point = new ComposedImage.Point();

        private OverlayPosition(int x, int y) {
            this.point.x = x;
            this.point.y = y;
        }
    }
}

