/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.model2ecore.internal.util;

import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcorePackage;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;

public class ModelHelper {
    private static final int ECORE_MANY_CARDINALITY = -1;
    private static final String CAPELLA_MANY_CARDINALITY = "*";

    private ModelHelper() {
    }

    public static String getPackageDelegationAnnotationName(AbstractDependenciesPkg package_p) {
        return ModelHelper.getPackageFullName(package_p, ".");
    }

    public static String getPackageFullName(AbstractDependenciesPkg package_p, String replaceSequence_p) {
        String newDelimiter = replaceSequence_p;
        if (newDelimiter == null) {
            newDelimiter = "-";
        }
        StringTokenizer tokenizer = new StringTokenizer(package_p.getFullLabel(), "/");
        tokenizer.nextToken();
        StringBuilder shortResourceName = new StringBuilder();
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            shortResourceName.append(token.replaceAll(" ", ""));
            if (!tokenizer.hasMoreTokens()) continue;
            shortResourceName.append(newDelimiter);
        }
        return shortResourceName.toString();
    }

    public static String forceCharactersToEcoreNamingConventions(String name_p) {
        if (name_p == null) {
            return name_p;
        }
        return name_p.replaceAll(" ", "");
    }

    public static int getValue(LiteralNumericValue value_p) {
        int intValue;
        if (value_p.getValue().contains(CAPELLA_MANY_CARDINALITY)) {
            return -1;
        }
        try {
            intValue = Integer.parseInt(value_p.getValue());
        }
        catch (NumberFormatException exception_p) {
            intValue = 0;
        }
        return intValue;
    }

    public static EClassifier getClassifier(AbstractPropertyValue capellaPropertyValue_p) {
        EDataType result = null;
        switch (capellaPropertyValue_p.eClass().getClassifierID()) {
            case 33: {
                result = EcorePackage.Literals.EBOOLEAN;
                break;
            }
            case 34: {
                result = EcorePackage.Literals.EFLOAT;
                break;
            }
            case 32: {
                result = EcorePackage.Literals.EINT;
            }
        }
        return result;
    }
}

