/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.model2ecore.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.model2ecore.internal.converters.DataTypeConverter;
import org.polarsys.capella.model2ecore.internal.util.AbstractModelElementHandler;
import org.polarsys.capella.model2ecore.internal.util.ModelHelper;

public abstract class AbstractEcoreExporterCommand {
    protected static final String NS_URI_PREFIX = "http://www.polarsys.org";
    protected static final String ECORE_ANNOTATION = "http://www.eclipse.org/emf/2002/Ecore";
    protected static final String GENMODEL_ANNOTATION = "http://www.eclipse.org/emf/2002/GenModel";
    protected static final String DELEGATE_ANNOTATION_ENTRY_KEY = "invocationDelegates";
    protected static final String DOCUMENTATION_ANNOTATION_ENTRY_KEY = "documentation";
    private List<EPackage> ecoreRootPackages;
    private Map<ModelElement, EClassifier> _capellaToEcoreMappings;
    private Map<AbstractDependenciesPkg, EPackage> packagesMappings;

    protected AbstractEcoreExporterCommand() {
        this(new HashMap<ModelElement, EClassifier>(0), new HashMap<AbstractDependenciesPkg, EPackage>(0));
    }

    protected AbstractEcoreExporterCommand(Map<ModelElement, EClassifier> capellaToEcoreMappings, Map<AbstractDependenciesPkg, EPackage> packagesMappings) {
        this._capellaToEcoreMappings = capellaToEcoreMappings;
        this.packagesMappings = packagesMappings;
        this.ecoreRootPackages = new ArrayList<EPackage>(1);
    }

    protected EPackage createEPackage(AbstractDependenciesPkg pkg) {
        EPackage ecorePackage = EcoreFactory.eINSTANCE.createEPackage();
        String packageName = ModelHelper.forceCharactersToEcoreNamingConventions(pkg.getName());
        ecorePackage.setName(packageName);
        ecorePackage.setNsPrefix(packageName);
        StringBuilder nsURI = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(pkg.getFullLabel(), "/");
        tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            nsURI.append('/').append(tokenizer.nextToken());
        }
        ecorePackage.setNsURI(NS_URI_PREFIX + ModelHelper.forceCharactersToEcoreNamingConventions(nsURI.toString()));
        this.getPackagesMappings().put(pkg, ecorePackage);
        return ecorePackage;
    }

    protected void dispose() {
    }

    public void export(AbstractDependenciesPkg capellaRootPackage) {
        this.getEcoreRootPackages().clear();
        EPackage rootEPackage = this.createEPackage(capellaRootPackage);
        this.getEcoreRootPackages().add(rootEPackage);
        this.exportPackage(capellaRootPackage, rootEPackage);
        this.dispose();
    }

    protected abstract void exportPackage(AbstractDependenciesPkg var1, EPackage var2);

    public List<EPackage> getEcoreRootPackages() {
        return this.ecoreRootPackages;
    }

    protected EClassifier getEcoreType(AbstractType capellaType) {
        EClassifier ecoreDataType = this._capellaToEcoreMappings.get(capellaType);
        if (ecoreDataType == null) {
            ecoreDataType = (EClassifier)new DataTypeConverter().doSwitch((EObject)capellaType);
            if (!EcorePackage.eINSTANCE.equals(ecoreDataType.eContainer())) {
                AbstractDependenciesPkg dataPackageContainer = (AbstractDependenciesPkg)EcoreUtil2.getFirstContainer((EObject)capellaType, (EClass)CapellacorePackage.Literals.ABSTRACT_DEPENDENCIES_PKG);
                EPackage ecorePackage = this.packagesMappings.get(dataPackageContainer);
                if (ecorePackage == null) {
                    ecorePackage = this.createEPackage(dataPackageContainer);
                    this.ecoreRootPackages.add(ecorePackage);
                }
                ecorePackage.getEClassifiers().add((Object)ecoreDataType);
            }
            this._capellaToEcoreMappings.put((ModelElement)capellaType, ecoreDataType);
        }
        return ecoreDataType;
    }

    protected Map<ModelElement, EClassifier> getCapellaToEcoreMappings() {
        return this._capellaToEcoreMappings;
    }

    protected Map<AbstractDependenciesPkg, EPackage> getPackagesMappings() {
        return this.packagesMappings;
    }

    protected void walkThroughPackageContent(AbstractDependenciesPkg capellaPackage, EPackage parentPackage, AbstractModelElementHandler contentHandler) {
        EList contents = capellaPackage.eContents();
        Iterator iterator = contents.iterator();
        EList eClassifiers = parentPackage.getEClassifiers();
        while (iterator.hasNext()) {
            ModelElement currentElement = (ModelElement)iterator.next();
            Couple<EClassifier, Boolean> result = contentHandler.handleElement(currentElement, parentPackage, this);
            EClassifier classifier = (EClassifier)result.getKey();
            boolean shouldPersistInResultingEcore = (Boolean)result.getValue();
            if (classifier == null) continue;
            if (shouldPersistInResultingEcore) {
                eClassifiers.add((Object)classifier);
            }
            this._capellaToEcoreMappings.put(currentElement, classifier);
        }
    }
}

