/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.model2ecore.actions;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.model2ecore.CapellaEcoreExporterActivator;
import org.polarsys.capella.model2ecore.actions.Messages;
import org.polarsys.capella.model2ecore.command.AbstractEcoreExporterCommand;
import org.polarsys.capella.model2ecore.command.DataPkgToEcoreExporterCommand;
import org.polarsys.capella.model2ecore.command.InterfacePkgToEcoreExporter;
import org.polarsys.capella.model2ecore.dialogs.ExporterDestinationDialog;
import org.polarsys.capella.model2ecore.internal.util.ModelHelper;

public class EcoreExporterAction
extends BaseSelectionListenerAction {
    private static final Logger __logger = Logger.getLogger((String)EcoreExporterAction.class.getPackage().getName());

    public EcoreExporterAction() {
        super(Messages.EcoreExporterAction_Title);
        this.setImageDescriptor(CapellaEcoreExporterActivator.getDefault().getImageDescriptor("full/ctool16/NewEcore.gif"));
    }

    private String computeResourcePath(AbstractDependenciesPkg pkg, String selectedDirectory) {
        String shortResourceName = ModelHelper.getPackageFullName(pkg, null);
        return new Path(selectedDirectory).append(shortResourceName).addFileExtension("ecore").toString();
    }

    protected void handlePackage(AbstractEcoreExporterCommand exporter, AbstractDependenciesPkg capellaPackage, ResourceSet resourceSet, String destinationFolder) {
        if (capellaPackage != null) {
            exporter.export(capellaPackage);
            String ecoreResourceName = this.computeResourcePath(capellaPackage, destinationFolder);
            this.serialize(resourceSet, URI.createFileURI((String)ecoreResourceName), exporter.getEcoreRootPackages());
        }
    }

    public void run() {
        ExporterDestinationDialog dialog = new ExporterDestinationDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        if (dialog.open() == 0) {
            IStructuredSelection structuredSelection = this.getStructuredSelection();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            HashMap<ModelElement, EClassifier> capellaToEcoreMappings = new HashMap<ModelElement, EClassifier>(0);
            HashMap<AbstractDependenciesPkg, EPackage> packagesMappings = new HashMap<AbstractDependenciesPkg, EPackage>(0);
            IPreferenceStore preferenceStore = CapellaEcoreExporterActivator.getDefault().getPreferenceStore();
            BlockArchitecture architecture = (BlockArchitecture)structuredSelection.getFirstElement();
            DataPkg dataPackage = architecture.getOwnedDataPkg();
            String dataPackageFolder = preferenceStore.getString("dataPackageEcoreModelFolder");
            this.handlePackage(new DataPkgToEcoreExporterCommand(capellaToEcoreMappings, packagesMappings), (AbstractDependenciesPkg)dataPackage, (ResourceSet)resourceSet, dataPackageFolder);
            if (preferenceStore.getBoolean("interfacePackageEcoreModelExport")) {
                InterfacePkg ownedInterfacePkg = architecture.getOwnedInterfacePkg();
                String interfacePackageFolder = preferenceStore.getString("interfacePackageEcoreModelFolder");
                this.handlePackage(new InterfacePkgToEcoreExporter(capellaToEcoreMappings, packagesMappings), (AbstractDependenciesPkg)ownedInterfacePkg, (ResourceSet)resourceSet, interfacePackageFolder);
            }
        }
    }

    protected void serialize(ResourceSet resourceSet, URI resourceURI, List<EPackage> packages) {
        Resource ecoreResource = resourceSet.createResource(resourceURI);
        ecoreResource.getContents().addAll(packages);
        try {
            ecoreResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException exception) {
            StringBuilder loggerMessage = new StringBuilder("EcoreExporterCommand.serialize(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
        }
    }
}

