/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.command.recorder.core.output;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.polarsys.capella.command.recorder.core.preferences.RecorderCorePreferenceServices;
import org.polarsys.capella.command.recorder.core.recorder.IRecorder;

public class OutputHelper {
    public static final String LOG_EXT = ".log";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static Writer logForStream(OutputStream output) {
        try {
            return new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new BufferedWriter(new OutputStreamWriter(output));
        }
    }

    public static List<File> getRecordFiles(IRecorder recorder) {
        return OutputHelper.getRecordFiles(OutputHelper.getDir(recorder));
    }

    public static List<File> getRecordFiles(File dir) {
        FilenameFilter filter;
        File[] files;
        ArrayList<File> result = new ArrayList<File>();
        if (OutputHelper.isDirectoryOk(dir) && (files = dir.listFiles(filter = new FilenameFilter(){

            @Override
            public boolean accept(File directory, String name) {
                return OutputHelper.isDirectoryOk(directory) && name != null && name.endsWith(OutputHelper.LOG_EXT);
            }
        })) != null && files.length > 0) {
            result.add(files[0]);
            File file = null;
            int i = 1;
            while (i < files.length) {
                file = files[i];
                int index = -1;
                int j = 0;
                while (j < result.size()) {
                    if (!OutputHelper.isOlder(file, (File)result.get(j))) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                if (-1 != index) {
                    result.add(index, file);
                } else {
                    result.add(file);
                }
                ++i;
            }
        }
        return result;
    }

    public static List<File> getDeprecatedRecordFiles(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        Date date = new Date();
        List<File> files = OutputHelper.getRecordFiles(dir);
        int sz = files.size();
        Iterator<File> it = files.iterator();
        int idx = 0;
        File current = null;
        while (it.hasNext()) {
            current = it.next();
            if (OutputHelper.isOutOfTime(current, date)) break;
            ++idx;
        }
        if (idx < sz) {
            result.addAll(files.subList(idx, sz));
        }
        return result;
    }

    public static boolean isOutOfTime(File file, Date refDate) {
        boolean result = true;
        if (file == null || !file.exists()) {
            result = true;
        } else {
            Date date = refDate == null ? new Date() : refDate;
            long ref = date.getTime() - (long)(RecorderCorePreferenceServices.getHistoryDelay() * 1000 * 24 * 3600);
            result = file.lastModified() < ref;
        }
        return result;
    }

    public static File getRootDirectoryForStorage() {
        return new File(RecorderCorePreferenceServices.getRootRecordPath());
    }

    public static File getDir(IRecorder recorder) {
        String path = RecorderCorePreferenceServices.getRootRecordPath();
        if (recorder != null && recorder.getRelativePath() != null && recorder.getRelativePath().length() != 0) {
            path = String.valueOf(path) + FILE_SEPARATOR + recorder.getRelativePath();
        }
        return new File(path);
    }

    public static boolean isOverSized(File file) {
        long max = RecorderCorePreferenceServices.getMaxFileSize() * 1024 * 1024;
        long sz = file.length();
        return sz >= max;
    }

    public static File createNewLogFile(IRecorder recorder) {
        File result = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh-mm");
        String pathname = String.valueOf(OutputHelper.getDir(recorder).getPath()) + FILE_SEPARATOR + dateFormat.format(new Date()) + LOG_EXT;
        result = new File(pathname);
        return result;
    }

    public static void cleanUpStorageArea(File dir) {
        OutputHelper.deleteFiles(OutputHelper.getDeprecatedRecordFiles(dir));
    }

    public static void cleanUpStorageAreaForRecords(Set<? extends IRecorder> recorders) {
        List<File> allDirectories = OutputHelper.getDirectSubDirectory(OutputHelper.getRootDirectoryForStorage());
        File dir = null;
        for (IRecorder iRecorder : recorders) {
            dir = OutputHelper.getDir(iRecorder);
            if (allDirectories.contains(dir)) {
                allDirectories.remove(dir);
            }
            OutputHelper.cleanUpStorageArea(dir);
        }
    }

    public static boolean cleanAllRecordsFile(File dir, boolean deleteFolder) {
        boolean result = false;
        if (OutputHelper.isDirectoryOk(dir)) {
            if (deleteFolder) {
                result = dir.delete();
            } else {
                OutputHelper.deleteFiles(OutputHelper.getRecordFiles(dir));
            }
        }
        return result;
    }

    public static List<File> getDirectSubDirectory(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        if (OutputHelper.isDirectoryOk(dir)) {
            File[] files = dir.listFiles();
            File current = null;
            int i = 0;
            while (i < files.length) {
                current = files[i];
                if (OutputHelper.isDirectoryOk(current)) {
                    result.add(current);
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean deleteFiles(List<File> files) {
        return files == null || files.isEmpty() ? true : OutputHelper.deleteFiles(files.toArray(new File[0]));
    }

    public static boolean deleteFiles(File[] files) {
        boolean result = true;
        if (files == null) {
            result = false;
        } else {
            int i = 0;
            while (i < files.length) {
                result &= OutputHelper.deleteFile(files[i]);
                ++i;
            }
        }
        return result;
    }

    public static boolean deleteFile(File file) {
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (files[i].isDirectory()) {
                        OutputHelper.deleteFile(files[i]);
                    } else {
                        files[i].delete();
                    }
                    ++i;
                }
            }
            file.delete();
        }
        return true;
    }

    private static boolean isDirectoryOk(File dir) {
        return dir != null && dir.exists() && dir.isDirectory();
    }

    private static boolean isOlder(File file1, File file2) {
        return file1.lastModified() < file2.lastModified();
    }
}

