/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import org.eclipse.buildship.core.internal.UnsupportedConfigurationException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class ValidateProjectLocationOperation {
    private static final File WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
    private final Set<EclipseProject> projects;

    public ValidateProjectLocationOperation(Set<? extends EclipseProject> projects) {
        this.projects = ImmutableSet.copyOf(projects);
    }

    public void run(IProgressMonitor monitor) {
        for (EclipseProject project : this.projects) {
            if (!project.getProjectDirectory().equals(WORKSPACE_ROOT)) continue;
            throw new UnsupportedConfigurationException(String.format("Project %s location matches workspace root %s", project.getName(), WORKSPACE_ROOT.getAbsolutePath()));
        }
    }
}

