/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.action;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public abstract class CommandBackedAction
extends Action {
    private final String commandId;

    protected CommandBackedAction(String commandId) {
        this(commandId, 0);
    }

    protected CommandBackedAction(String commandId, int style) {
        super(null, style);
        this.commandId = (String)Preconditions.checkNotNull((Object)commandId);
    }

    public void runWithEvent(Event event) {
        try {
            this.getHandlerService().executeCommand(this.commandId, event);
        }
        catch (Exception e) {
            String message = String.format("Cannot execute command for action '%s'.", this.getText());
            UiPlugin.logger().error(message, (Throwable)e);
            throw new GradlePluginsRuntimeException(message, (Throwable)e);
        }
    }

    private IHandlerService getHandlerService() {
        return (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
    }
}

