/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.util.widget;

import com.google.common.base.Preconditions;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class HoverText {
    private final Control target;
    private final String text;
    private AbstractInformationControl hover;

    private HoverText(Control target, String text) {
        this.target = (Control)Preconditions.checkNotNull((Object)target);
        this.text = (String)Preconditions.checkNotNull((Object)text);
    }

    public static HoverText createAndAttach(Control target, String text) {
        HoverText hoverHelp = new HoverText(target, text);
        hoverHelp.createControl(target.getShell());
        return hoverHelp;
    }

    private void createControl(Shell parent) {
        this.hover = new DefaultInformationControl(parent, "Gradle Info");
        this.hover.setSizeConstraints(300, 300);
        this.hover.setInformation(this.text);
        Point size = this.hover.computeSizeHint();
        this.hover.setSize(size.x, size.y);
        this.addListeners();
    }

    private void addListeners() {
        MouseHoverEventListener listener = new MouseHoverEventListener();
        this.target.addMouseListener((MouseListener)listener);
        this.target.addMouseMoveListener((MouseMoveListener)listener);
        this.target.addMouseTrackListener((MouseTrackListener)listener);
    }

    private class MouseHoverEventListener
    extends MouseTrackAdapter
    implements MouseListener,
    MouseMoveListener {
        private Widget currentWidget;

        private MouseHoverEventListener() {
        }

        public void mouseMove(MouseEvent event) {
            Point point = new Point(event.x, event.y);
            Widget widget = event.widget;
            if (widget == null) {
                HoverText.this.hover.setVisible(false);
                this.currentWidget = null;
                return;
            }
            if (widget == this.currentWidget) {
                return;
            }
            this.currentWidget = widget;
            HoverText.this.hover.setInformation(HoverText.this.text);
            Point currentPosition = HoverText.this.target.toDisplay(point);
            this.setHoverLocation(currentPosition);
            HoverText.this.hover.setVisible(true);
        }

        private void setHoverLocation(Point position) {
            Rectangle displayBounds = HoverText.this.target.getDisplay().getBounds();
            Rectangle shellBounds = HoverText.this.hover.getBounds();
            int x = Math.max(Math.min(position.x, displayBounds.width - shellBounds.width), 0);
            int y = Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
            HoverText.this.hover.setLocation(new Point(x, y));
        }

        public void mouseExit(MouseEvent event) {
            if (HoverText.this.hover.isVisible()) {
                HoverText.this.hover.setVisible(false);
            }
            this.currentWidget = null;
        }

        public void mouseDown(MouseEvent event) {
            if (HoverText.this.hover.isVisible()) {
                HoverText.this.hover.setVisible(false);
            }
        }

        public void mouseDoubleClick(MouseEvent event) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

