/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.InitializationContext;
import org.eclipse.buildship.core.ProjectConfigurator;
import org.eclipse.buildship.core.ProjectContext;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.internal.UnsupportedConfigurationException;
import org.eclipse.buildship.core.internal.marker.GradleErrorMarker;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.GradleClasspathContainer;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.ModelProviderUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.model.eclipse.ClasspathAttribute;
import org.gradle.tooling.model.eclipse.EclipseExternalDependency;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class WtpConfigurator
implements ProjectConfigurator {
    private static final String DEPLOYMENT_ATTRIBUTE = "org.eclipse.jst.component.dependency";
    private static final String NON_DEPLOYMENT_ATTRIBUTE = "org.eclipse.jst.component.nondependency";
    private DefaultGradleBuild gradleBuild;
    private Map<File, EclipseProject> locationToProject;

    @Override
    public void init(InitializationContext context, IProgressMonitor monitor) {
        GradleBuild gradleBuild = context.getGradleBuild();
        this.gradleBuild = (DefaultGradleBuild)gradleBuild;
        Set<EclipseProject> eclipseProjects = ModelProviderUtil.fetchAllEclipseProjects(this.gradleBuild, GradleConnector.newCancellationTokenSource(), FetchStrategy.LOAD_IF_NOT_CACHED, monitor);
        this.locationToProject = eclipseProjects.stream().collect(Collectors.toMap(p -> p.getProjectDirectory(), p -> p));
    }

    @Override
    public void configure(ProjectContext context, IProgressMonitor monitor) {
        IProject project = context.getProject();
        try {
            EclipseProject model = this.lookupEclipseModel(project);
            WtpConfigurator.updateWtpConfiguration(context, JavaCore.create((IProject)project), model, this.gradleBuild, monitor);
        }
        catch (CoreException e) {
            context.error("Failed to configure WTP for project " + project.getName(), (Exception)((Object)e));
        }
    }

    private EclipseProject lookupEclipseModel(IProject project) {
        IPath path = project.getLocation();
        if (path == null) {
            return null;
        }
        return this.locationToProject.get(path.toFile());
    }

    @Override
    public void unconfigure(ProjectContext context, IProgressMonitor monitor) {
    }

    private static void updateWtpConfiguration(ProjectContext context, IJavaProject javaProject, EclipseProject project, InternalGradleBuild gradleBuild, IProgressMonitor monitor) throws JavaModelException {
        if (CorePlugin.workspaceOperations().isWtpInstalled()) {
            try {
                ArrayList dependencies = Lists.newArrayList((Iterable)project.getClasspath());
                String deploymentPath = WtpConfigurator.getDeploymentPath(context, dependencies);
                if (deploymentPath != null) {
                    WtpConfigurator.updateDeploymentPath(javaProject, deploymentPath, monitor);
                } else if (WtpConfigurator.hasNonDeploymentAttributes(dependencies)) {
                    WtpConfigurator.markAsNonDeployed(javaProject, monitor);
                }
            }
            catch (UnsupportedConfigurationException e) {
                GradleErrorMarker.createError((IResource)javaProject.getProject(), gradleBuild, e.getMessage(), null, 0);
            }
        }
    }

    private static String getDeploymentPath(ProjectContext context, List<EclipseExternalDependency> dependencies) {
        String deploymentPath = null;
        for (EclipseExternalDependency dependency : dependencies) {
            for (ClasspathAttribute attribute : dependency.getClasspathAttributes()) {
                if (!attribute.getName().equals(DEPLOYMENT_ATTRIBUTE)) continue;
                if (deploymentPath != null && !deploymentPath.equals(attribute.getValue())) {
                    context.error("WTP currently does not support mixed deployment paths.", null);
                    return null;
                }
                deploymentPath = attribute.getValue();
            }
        }
        return deploymentPath;
    }

    private static boolean hasNonDeploymentAttributes(List<EclipseExternalDependency> dependencies) {
        for (EclipseExternalDependency dependency : dependencies) {
            for (ClasspathAttribute attribute : dependency.getClasspathAttributes()) {
                if (!attribute.getName().equals(NON_DEPLOYMENT_ATTRIBUTE)) continue;
                return true;
            }
        }
        return false;
    }

    private static void updateDeploymentPath(IJavaProject javaProject, String deploymentPath, IProgressMonitor monitor) throws JavaModelException {
        WtpConfigurator.replaceGradleClasspathContainerAttribute(javaProject, DEPLOYMENT_ATTRIBUTE, deploymentPath, NON_DEPLOYMENT_ATTRIBUTE, monitor);
    }

    private static void markAsNonDeployed(IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        WtpConfigurator.replaceGradleClasspathContainerAttribute(javaProject, NON_DEPLOYMENT_ATTRIBUTE, "", DEPLOYMENT_ATTRIBUTE, monitor);
    }

    private static void replaceGradleClasspathContainerAttribute(IJavaProject project, String plusKey, String plusValue, String minusKey, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] oldClasspath = project.getRawClasspath();
        IClasspathEntry[] newClasspath = new IClasspathEntry[oldClasspath.length];
        for (int i = 0; i < oldClasspath.length; ++i) {
            IClasspathEntry entry = oldClasspath[i];
            if (WtpConfigurator.isGradleClasspathContainer(entry)) {
                IClasspathAttribute[] attributes = WtpConfigurator.replaceClasspathAttribute(entry.getExtraAttributes(), plusKey, plusValue, minusKey);
                newClasspath[i] = JavaCore.newContainerEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])attributes, (boolean)entry.isExported());
                continue;
            }
            newClasspath[i] = entry;
        }
        project.setRawClasspath(newClasspath, monitor);
    }

    private static boolean isGradleClasspathContainer(IClasspathEntry entry) {
        return entry.getEntryKind() == 5 && entry.getPath().equals((Object)GradleClasspathContainer.CONTAINER_PATH);
    }

    private static IClasspathAttribute[] replaceClasspathAttribute(IClasspathAttribute[] attributes, String plusKey, String plusValue, String minusKey) {
        ArrayList attributesList = Lists.newArrayList((Object[])attributes);
        ListIterator<IClasspathAttribute> iterator = attributesList.listIterator();
        boolean plusPresent = false;
        while (iterator.hasNext()) {
            IClasspathAttribute attribute = (IClasspathAttribute)iterator.next();
            if (attribute.getName().equals(minusKey)) {
                iterator.remove();
                continue;
            }
            if (!attribute.getName().equals(plusKey)) continue;
            plusPresent = true;
            if (attribute.getValue().equals(plusValue)) continue;
            iterator.set(JavaCore.newClasspathAttribute((String)plusKey, (String)plusValue));
        }
        if (!plusPresent) {
            attributesList.add(JavaCore.newClasspathAttribute((String)plusKey, (String)plusValue));
        }
        return attributesList.toArray(new IClasspathAttribute[attributesList.size()]);
    }
}

