/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.GradleBuilds;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.workspace.internal.SynchronizeGradleBuildsJob;

public class DefaultGradleBuilds
implements GradleBuilds {
    private final ImmutableSet<GradleBuild> gradleBuilds;

    public DefaultGradleBuilds(Set<BuildConfiguration> buildConfigs) {
        ImmutableSet.Builder builds = ImmutableSet.builder();
        for (BuildConfiguration buildConfig : buildConfigs) {
            builds.add((Object)new DefaultGradleBuild(buildConfig));
        }
        this.gradleBuilds = builds.build();
    }

    @Override
    public void synchronize(NewProjectHandler newProjectHandler) {
        SynchronizeGradleBuildsJob.forMultipleGradleBuilds(this, newProjectHandler, AsyncHandler.NO_OP).schedule();
    }

    @Override
    public Iterator<GradleBuild> iterator() {
        return ImmutableSet.copyOf(this.getGradleBuilds()).iterator();
    }

    public ImmutableSet<GradleBuild> getGradleBuilds() {
        return this.gradleBuilds;
    }
}

