/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectNature;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

final class ProjectNatureUpdater {
    ProjectNatureUpdater() {
    }

    public static void update(IProject project, Optional<List<OmniEclipseProjectNature>> projectNatures, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        Set<String> natures = ProjectNatureUpdater.toNatures(projectNatures, description);
        description.setNatureIds(natures.toArray(new String[0]));
        project.setDescription(description, monitor);
    }

    private static Set<String> toNatures(Optional<List<OmniEclipseProjectNature>> projectNatures, IProjectDescription description) {
        LinkedHashSet natures = Sets.newLinkedHashSet();
        if (projectNatures.isPresent()) {
            natures.addAll(ProjectNatureUpdater.toNatures((List)projectNatures.get()));
        } else {
            natures.addAll(Arrays.asList(description.getNatureIds()));
        }
        natures.add("org.eclipse.buildship.core.gradleprojectnature");
        return natures;
    }

    private static Set<? extends String> toNatures(List<OmniEclipseProjectNature> projectNatures) {
        LinkedHashSet natures = Sets.newLinkedHashSet();
        for (OmniEclipseProjectNature projectNature : projectNatures) {
            String id = projectNature.getId();
            if (!CorePlugin.workspaceOperations().isNatureRecognizedByEclipse(id)) continue;
            natures.add(id);
        }
        return natures;
    }
}

