/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.OmniEclipseBuildCommand;
import com.gradleware.tooling.toolingmodel.OmniEclipseClasspathContainer;
import com.gradleware.tooling.toolingmodel.OmniEclipseOutputLocation;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectNature;
import com.gradleware.tooling.toolingmodel.OmniJavaSourceSettings;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.BuildCommandUpdater;
import org.eclipse.buildship.core.workspace.internal.ClasspathContainerUpdater;
import org.eclipse.buildship.core.workspace.internal.DerivedResourcesUpdater;
import org.eclipse.buildship.core.workspace.internal.GradleClasspathContainerUpdater;
import org.eclipse.buildship.core.workspace.internal.JavaSourceSettingsUpdater;
import org.eclipse.buildship.core.workspace.internal.LibraryFilter;
import org.eclipse.buildship.core.workspace.internal.LinkedResourcesUpdater;
import org.eclipse.buildship.core.workspace.internal.OutputLocationUpdater;
import org.eclipse.buildship.core.workspace.internal.PersistentModelBuilder;
import org.eclipse.buildship.core.workspace.internal.ProjectNameUpdater;
import org.eclipse.buildship.core.workspace.internal.ProjectNatureUpdater;
import org.eclipse.buildship.core.workspace.internal.SourceFolderUpdater;
import org.eclipse.buildship.core.workspace.internal.SubprojectMarkerUpdater;
import org.eclipse.buildship.core.workspace.internal.WtpClasspathUpdater;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

final class SynchronizeGradleBuildOperation
implements IWorkspaceRunnable {
    private final Set<OmniEclipseProject> allProjects;
    private final FixedRequestAttributes build;
    private final NewProjectHandler newProjectHandler;

    SynchronizeGradleBuildOperation(Set<OmniEclipseProject> allProjects, FixedRequestAttributes build, NewProjectHandler newProjectHandler) {
        this.allProjects = allProjects;
        this.build = build;
        this.newProjectHandler = newProjectHandler;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setTaskName(String.format("Synchronizing Gradle build at %s", this.build.getProjectDir()));
        this.synchronizeProjectsWithWorkspace(progress);
    }

    private void synchronizeProjectsWithWorkspace(SubMonitor progress) throws CoreException {
        List<IProject> decoupledWorkspaceProjects = this.getOpenWorkspaceProjectsRemovedFromGradleBuild();
        progress.setWorkRemaining(decoupledWorkspaceProjects.size() + this.allProjects.size());
        for (IProject project : decoupledWorkspaceProjects) {
            this.uncoupleWorkspaceProjectFromGradle(project, progress.newChild(1));
        }
        for (final OmniEclipseProject gradleProject : this.allProjects) {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SynchronizeGradleBuildOperation.this.synchronizeGradleProjectWithWorkspaceProject(gradleProject, SubMonitor.convert((IProgressMonitor)monitor));
                }
            }, (IProgressMonitor)progress.newChild(1));
        }
    }

    private List<IProject> getOpenWorkspaceProjectsRemovedFromGradleBuild() {
        ImmutableSet gradleProjectDirectories = FluentIterable.from(this.allProjects).transform((Function)new Function<OmniEclipseProject, File>(){

            public File apply(OmniEclipseProject gradleProject) {
                return gradleProject.getProjectDirectory();
            }
        }).toSet();
        ImmutableList<IProject> allWorkspaceProjects = CorePlugin.workspaceOperations().getAllProjects();
        return FluentIterable.from(allWorkspaceProjects).filter(GradleProjectNature.isPresentOn()).filter((Predicate)new Predicate<IProject>((Set)gradleProjectDirectories){
            final /* synthetic */ Set val$gradleProjectDirectories;
            {
                this.val$gradleProjectDirectories = set;
            }

            public boolean apply(IProject project) {
                Optional<ProjectConfiguration> projectConfiguration = CorePlugin.projectConfigurationManager().tryReadProjectConfiguration(project);
                return projectConfiguration.isPresent() && ((ProjectConfiguration)projectConfiguration.get()).toRequestAttributes(ProjectConfiguration.ConversionStrategy.MERGE_WORKSPACE_SETTINGS).getProjectDir().equals(SynchronizeGradleBuildOperation.this.build.getProjectDir()) && (project.getLocation() == null || !this.val$gradleProjectDirectories.contains(project.getLocation().toFile()));
            }
        }).toList();
    }

    private void synchronizeGradleProjectWithWorkspaceProject(OmniEclipseProject project, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(1);
        progress.subTask(String.format("Synchronize Gradle project %s with workspace project", project.getName()));
        Optional<IProject> workspaceProject = CorePlugin.workspaceOperations().findProjectByLocation(project.getProjectDirectory());
        SubMonitor childProgress = progress.newChild(1, 7);
        if (workspaceProject.isPresent()) {
            this.synchronizeWorkspaceProject(project, (IProject)workspaceProject.get(), childProgress);
        } else if (project.getProjectDirectory().exists() && this.newProjectHandler.shouldImport(project)) {
            this.synchronizeNonWorkspaceProject(project, childProgress);
        }
    }

    private void synchronizeWorkspaceProject(OmniEclipseProject project, IProject workspaceProject, SubMonitor progress) throws CoreException {
        if (workspaceProject.isAccessible()) {
            this.synchronizeOpenWorkspaceProject(project, workspaceProject, progress);
        } else {
            this.synchronizeClosedWorkspaceProject(progress);
        }
    }

    private void synchronizeOpenWorkspaceProject(OmniEclipseProject project, IProject workspaceProject, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(9);
        CorePlugin.workspaceOperations().refreshProject(workspaceProject, (IProgressMonitor)progress.newChild(1));
        workspaceProject = ProjectNameUpdater.updateProjectName(workspaceProject, project, this.allProjects, (IProgressMonitor)progress.newChild(1));
        CorePlugin.workspaceOperations().addNature(workspaceProject, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)progress.newChild(1));
        ProjectConfiguration configuration = ProjectConfiguration.from(this.build, project);
        CorePlugin.projectConfigurationManager().saveProjectConfiguration(configuration, workspaceProject);
        PersistentModelBuilder persistentModel = new PersistentModelBuilder(CorePlugin.modelPersistence().loadModel(workspaceProject));
        LinkedResourcesUpdater.update(workspaceProject, project.getLinkedResources(), persistentModel, (IProgressMonitor)progress.newChild(1));
        SubprojectMarkerUpdater.update(workspaceProject, project, persistentModel, (IProgressMonitor)progress.newChild(1));
        DerivedResourcesUpdater.update(workspaceProject, project, persistentModel, (IProgressMonitor)progress.newChild(1));
        ProjectNatureUpdater.update(workspaceProject, (Optional<List<OmniEclipseProjectNature>>)project.getProjectNatures(), (IProgressMonitor)progress.newChild(1));
        BuildCommandUpdater.update(workspaceProject, (Optional<List<OmniEclipseBuildCommand>>)project.getBuildCommands(), (IProgressMonitor)progress.newChild(1));
        if (this.isJavaProject(project)) {
            this.synchronizeJavaProject(project, workspaceProject, persistentModel, progress);
        } else {
            persistentModel.classpath((List<IClasspathEntry>)ImmutableList.of());
        }
        CorePlugin.modelPersistence().saveModel(persistentModel.build());
    }

    private void synchronizeJavaProject(final OmniEclipseProject project, final IProject workspaceProject, final PersistentModelBuilder persistentModel, SubMonitor progress) throws CoreException {
        JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                SynchronizeGradleBuildOperation.this.synchronizeJavaProjectInTransaction(project, workspaceProject, persistentModel, progress);
            }
        }, (IProgressMonitor)progress.newChild(1));
    }

    private void synchronizeJavaProjectInTransaction(OmniEclipseProject project, IProject workspaceProject, PersistentModelBuilder persistentModel, SubMonitor progress) throws JavaModelException, CoreException {
        progress.setWorkRemaining(8);
        CorePlugin.workspaceOperations().addNature(workspaceProject, "org.eclipse.jdt.core.javanature", (IProgressMonitor)progress.newChild(1));
        IJavaProject javaProject = JavaCore.create((IProject)workspaceProject);
        OutputLocationUpdater.update(javaProject, (Optional<OmniEclipseOutputLocation>)project.getOutputLocation(), (IProgressMonitor)progress.newChild(1));
        SourceFolderUpdater.update(javaProject, project.getSourceDirectories(), (IProgressMonitor)progress.newChild(1));
        LibraryFilter.update(javaProject, project, (IProgressMonitor)progress.newChild(1));
        ClasspathContainerUpdater.update(javaProject, (Optional<List<OmniEclipseClasspathContainer>>)project.getClasspathContainers(), (OmniJavaSourceSettings)project.getJavaSourceSettings().get(), (IProgressMonitor)progress.newChild(1));
        JavaSourceSettingsUpdater.update(javaProject, project, (IProgressMonitor)progress.newChild(1));
        GradleClasspathContainerUpdater.updateFromModel(javaProject, project, this.allProjects, persistentModel, (IProgressMonitor)progress.newChild(1));
        WtpClasspathUpdater.update(javaProject, project, progress.newChild(1));
    }

    private boolean isJavaProject(OmniEclipseProject project) {
        return project.getJavaSourceSettings().isPresent();
    }

    private void synchronizeClosedWorkspaceProject(SubMonitor childProgress) {
    }

    private void synchronizeNonWorkspaceProject(OmniEclipseProject project, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(2);
        Optional<IProjectDescription> projectDescription = CorePlugin.workspaceOperations().findProjectDescriptor(project.getProjectDirectory(), (IProgressMonitor)progress.newChild(1));
        IProject workspaceProject = projectDescription.isPresent() ? this.addExistingEclipseProjectToWorkspace(project, (IProjectDescription)projectDescription.get(), progress.newChild(1)) : this.addNewEclipseProjectToWorkspace(project, progress.newChild(1));
        this.newProjectHandler.afterImport(workspaceProject, project);
    }

    private IProject addExistingEclipseProjectToWorkspace(OmniEclipseProject project, IProjectDescription projectDescription, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(3);
        ProjectNameUpdater.ensureProjectNameIsFree(project, this.allProjects, (IProgressMonitor)progress.newChild(1));
        IProject workspaceProject = CorePlugin.workspaceOperations().includeProject(projectDescription, (List<String>)ImmutableList.of(), (IProgressMonitor)progress.newChild(1));
        this.synchronizeOpenWorkspaceProject(project, workspaceProject, progress.newChild(1));
        return workspaceProject;
    }

    private IProject addNewEclipseProjectToWorkspace(OmniEclipseProject project, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(3);
        ProjectNameUpdater.ensureProjectNameIsFree(project, this.allProjects, (IProgressMonitor)progress.newChild(1));
        IProject workspaceProject = CorePlugin.workspaceOperations().createProject(project.getName(), project.getProjectDirectory(), (List<String>)ImmutableList.of(), (IProgressMonitor)progress.newChild(1));
        this.synchronizeOpenWorkspaceProject(project, workspaceProject, progress.newChild(1));
        return workspaceProject;
    }

    private void uncoupleWorkspaceProjectFromGradle(IProject workspaceProject, SubMonitor monitor) {
        monitor.setWorkRemaining(3);
        monitor.subTask(String.format("Uncouple workspace project %s from Gradle", workspaceProject.getName()));
        CorePlugin.workspaceOperations().refreshProject(workspaceProject, (IProgressMonitor)monitor.newChild(1, 7));
        CorePlugin.workspaceOperations().removeNature(workspaceProject, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)monitor.newChild(1, 7));
        CorePlugin.modelPersistence().deleteModel(workspaceProject);
        CorePlugin.projectConfigurationManager().deleteProjectConfiguration(workspaceProject);
    }
}

