/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gradle.tooling.model.DomainObjectSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionMapper
implements Serializable {
    Collection<Object> createEmptyCollection(Class<?> collectionType) {
        if (collectionType.equals(DomainObjectSet.class)) {
            return new ArrayList<Object>();
        }
        if (collectionType.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<Object>();
        }
        if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            return new LinkedHashSet<Object>();
        }
        if (collectionType.isAssignableFrom(TreeSet.class)) {
            return new TreeSet<Object>();
        }
        throw new UnsupportedOperationException(String.format("Cannot convert a Collection to type %s.", collectionType.getName()));
    }

    Map<Object, Object> createEmptyMap(Class<?> mapType) {
        if (mapType.isAssignableFrom(LinkedHashMap.class)) {
            return new LinkedHashMap<Object, Object>();
        }
        if (mapType.isAssignableFrom(TreeMap.class)) {
            return new TreeMap<Object, Object>();
        }
        throw new UnsupportedOperationException(String.format("Cannot convert a Map to type %s.", mapType.getName()));
    }
}

