/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import org.eclipse.buildship.core.util.preference.EclipsePreferencesUtils;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.view.TreeViewerState;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public final class ExecutionViewState
implements TreeViewerState {
    private static final String PREF_SHOW_TREE_HEADER = "executionsView.showTreeHeader";
    private static final String PREF_HEADER_NAME_COLUMN_WIDTH = "executionsView.headerNameColumnWidth";
    private static final String PREF_HEADER_DURATION_COLUMN_WIDTH = "executionsView.headerDurationColumnWidth";
    private boolean showTreeHeader;
    private int headerNameColumnWidth;
    private int headerDurationColumnWidth;

    public void load() {
        IEclipsePreferences prefs = EclipsePreferencesUtils.getInstanceScope().getNode("org.eclipse.buildship.ui");
        this.showTreeHeader = prefs.getBoolean(PREF_SHOW_TREE_HEADER, false);
        this.headerNameColumnWidth = prefs.getInt(PREF_HEADER_NAME_COLUMN_WIDTH, 600);
        this.headerDurationColumnWidth = prefs.getInt(PREF_HEADER_DURATION_COLUMN_WIDTH, 100);
    }

    public void save() {
        IEclipsePreferences prefs = EclipsePreferencesUtils.getInstanceScope().getNode("org.eclipse.buildship.ui");
        prefs.putBoolean(PREF_SHOW_TREE_HEADER, this.showTreeHeader);
        prefs.putInt(PREF_HEADER_NAME_COLUMN_WIDTH, this.headerNameColumnWidth);
        prefs.putInt(PREF_HEADER_DURATION_COLUMN_WIDTH, this.headerDurationColumnWidth);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            UiPlugin.logger().error("Unable to store execution view preferences.", (Throwable)e);
        }
    }

    @Override
    public boolean isShowTreeHeader() {
        return this.showTreeHeader;
    }

    @Override
    public void setShowTreeHeader(boolean showTreeHeader) {
        this.showTreeHeader = showTreeHeader;
    }

    public int getHeaderNameColumnWidth() {
        return this.headerNameColumnWidth;
    }

    public void setHeaderNameColumnWidth(int headerNameColumnWidth) {
        this.headerNameColumnWidth = headerNameColumnWidth;
    }

    public int getHeaderDurationColumnWidth() {
        return this.headerDurationColumnWidth;
    }

    public void setHeaderDurationColumnWidth(int headerDurationColumnWidth) {
        this.headerDurationColumnWidth = headerDurationColumnWidth;
    }

    public void dispose() {
        this.save();
    }
}

