/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.model.Launchable;

public final class LaunchableConfig {
    private final ImmutableList<String> tasks;
    private final ImmutableList<Launchable> launchables;

    private LaunchableConfig(List<String> tasks, List<Launchable> launchables) {
        this.tasks = ImmutableList.copyOf(tasks);
        this.launchables = ImmutableList.copyOf(launchables);
        this.checkNoMoreThanOneListNotEmpty(tasks, launchables);
    }

    private void checkNoMoreThanOneListNotEmpty(List<String> tasks, List<Launchable> launchables) {
        Preconditions.checkArgument((tasks.isEmpty() || launchables.isEmpty() ? 1 : 0) != 0, (Object)"Both tasks and launchables specified.");
    }

    public void apply(BuildLauncher buildLauncher) {
        Preconditions.checkNotNull((Object)buildLauncher);
        if (!this.tasks.isEmpty()) {
            buildLauncher.forTasks((String[])this.tasks.toArray((Object[])new String[this.tasks.size()]));
        } else if (!this.launchables.isEmpty()) {
            buildLauncher.forLaunchables(this.launchables);
        }
    }

    public static LaunchableConfig forTasks(String ... tasks) {
        return LaunchableConfig.forTasks(Arrays.asList(tasks));
    }

    public static LaunchableConfig forTasks(Iterable<String> tasks) {
        return new LaunchableConfig((List<String>)ImmutableList.copyOf(tasks), (List<Launchable>)ImmutableList.of());
    }

    public static LaunchableConfig forLaunchables(Launchable ... launchables) {
        return LaunchableConfig.forLaunchables(Arrays.asList(launchables));
    }

    public static LaunchableConfig forLaunchables(Iterable<? extends Launchable> launchables) {
        return new LaunchableConfig((List<String>)ImmutableList.of(), (List<Launchable>)ImmutableList.copyOf(launchables));
    }
}

