/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.workspace.CompositeModelQuery;
import org.eclipse.buildship.core.internal.workspace.DefaultModelProvider;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.ProjectConnection;

public class BuildActionUtil {
    private static URLClassLoader ideFriendlyCustomActionClassLoader;

    private BuildActionUtil() {
    }

    public static <T> BuildAction<Collection<T>> compositeModelQuery(Class<T> model) {
        if (Platform.inDevelopmentMode()) {
            return BuildActionUtil.ideFriendlyCompositeModelQuery(model);
        }
        return new CompositeModelQuery<T>(model);
    }

    private static <T> BuildAction<Collection<T>> ideFriendlyCompositeModelQuery(Class<T> model) {
        try {
            ClassLoader coreClassloader = DefaultModelProvider.class.getClassLoader();
            ClassLoader tapiClassloader = ProjectConnection.class.getClassLoader();
            URL actionRootUrl = FileLocator.resolve((URL)coreClassloader.getResource(""));
            if (ideFriendlyCustomActionClassLoader == null) {
                ideFriendlyCustomActionClassLoader = new URLClassLoader(new URL[]{actionRootUrl}, tapiClassloader);
            }
            Class<?> actionClass = ideFriendlyCustomActionClassLoader.loadClass(CompositeModelQuery.class.getName());
            return (BuildAction)actionClass.getConstructor(Class.class).newInstance(model);
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(e);
        }
    }
}

