/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.buildship.core.launch.internal.LaunchConfigurationScope;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.DefaultProjectClasspathEntry;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.IRuntimeClasspathProvider;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardClasspathProvider;

public final class GradleClasspathProvider
extends StandardClasspathProvider
implements IRuntimeClasspathProvider {
    public static final String ID = "org.eclipse.buildship.core.classpathprovider";
    private static final IRuntimeClasspathEntry[] EMPTY_RESULT = new IRuntimeClasspathEntry[0];

    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        return this.filterUnusedDependencies(configuration, super.computeUnresolvedClasspath(configuration));
    }

    private IRuntimeClasspathEntry[] filterUnusedDependencies(ILaunchConfiguration configuration, IRuntimeClasspathEntry[] entriesToFilter) throws CoreException {
        IJavaProject project = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        IClasspathEntry[] classpath = project.getResolvedClasspath(true);
        LaunchConfigurationScope configurationScopes = LaunchConfigurationScope.from(configuration);
        HashSet excludedPaths = Sets.newHashSet();
        for (IClasspathEntry entry : classpath) {
            if (configurationScopes.isEntryIncluded(entry)) continue;
            excludedPaths.add(entry.getPath());
        }
        ArrayList<IRuntimeClasspathEntry> result = new ArrayList<IRuntimeClasspathEntry>(entriesToFilter.length);
        for (IRuntimeClasspathEntry entry : entriesToFilter) {
            if (excludedPaths.contains(entry.getPath())) continue;
            result.add(entry);
        }
        return result.toArray(new IRuntimeClasspathEntry[0]);
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        LinkedHashSet result = new LinkedHashSet(entries.length);
        block4: for (IRuntimeClasspathEntry entry : entries) {
            switch (entry.getType()) {
                case 5: {
                    Collections.addAll(result, this.resolveOther(entry, configuration));
                    continue block4;
                }
                case 1: {
                    Collections.addAll(result, this.resolveProject(entry, configuration));
                    continue block4;
                }
                default: {
                    Collections.addAll(result, JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, (ILaunchConfiguration)configuration));
                }
            }
        }
        return result.toArray(new IRuntimeClasspathEntry[result.size()]);
    }

    private IRuntimeClasspathEntry[] resolveOther(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        if (entry instanceof DefaultProjectClasspathEntry) {
            ArrayList result = new ArrayList();
            for (IRuntimeClasspathEntry e : ((IRuntimeClasspathEntry2)entry).getRuntimeClasspathEntries(configuration)) {
                Collections.addAll(result, this.resolveClasspath(new IRuntimeClasspathEntry[]{e}, configuration));
            }
            return result.toArray(new IRuntimeClasspathEntry[result.size()]);
        }
        return JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, (ILaunchConfiguration)configuration);
    }

    private IRuntimeClasspathEntry[] resolveProject(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        IResource resource = entry.getResource();
        if (resource instanceof IProject) {
            return this.resolveProject(entry, (IProject)resource, configuration);
        }
        return this.resolveOptional(entry);
    }

    private IRuntimeClasspathEntry[] resolveProject(IRuntimeClasspathEntry projectEntry, IProject project, ILaunchConfiguration configuration) throws CoreException {
        if (!project.isOpen()) {
            return EMPTY_RESULT;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return EMPTY_RESULT;
        }
        LaunchConfigurationScope configurationScopes = LaunchConfigurationScope.from(configuration);
        return GradleClasspathProvider.resolveOutputLocations(projectEntry, javaProject, configurationScopes);
    }

    private IRuntimeClasspathEntry[] resolveOptional(IRuntimeClasspathEntry entry) throws CoreException {
        if (GradleClasspathProvider.isOptional(entry.getClasspathEntry())) {
            return EMPTY_RESULT;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.buildship.core", String.format("The project: %s which is referenced by the classpath, does not exist", entry.getPath().lastSegment())));
    }

    private static boolean isOptional(IClasspathEntry entry) {
        for (IClasspathAttribute attribute : entry.getExtraAttributes()) {
            if (!"optional".equals(attribute.getName()) || !Boolean.parseBoolean(attribute.getValue())) continue;
            return true;
        }
        return false;
    }

    public static IRuntimeClasspathEntry[] resolveOutputLocations(IRuntimeClasspathEntry projectEntry, IJavaProject project, LaunchConfigurationScope configurationScopes) throws CoreException {
        ArrayList outputLocations = Lists.newArrayList();
        boolean hasSourceFolderWithoutCustomOutput = false;
        if (project.exists() && project.getProject().isOpen()) {
            for (IClasspathEntry entry : project.getRawClasspath()) {
                if (entry.getEntryKind() != 3 || !configurationScopes.isEntryIncluded(entry)) continue;
                IPath path = entry.getOutputLocation();
                if (path != null) {
                    outputLocations.add(path);
                    continue;
                }
                hasSourceFolderWithoutCustomOutput = true;
            }
        }
        if (outputLocations.isEmpty()) {
            return new IRuntimeClasspathEntry[]{projectEntry};
        }
        IPath defaultOutputLocation = project.getOutputLocation();
        if (!outputLocations.contains(defaultOutputLocation) && hasSourceFolderWithoutCustomOutput) {
            outputLocations.add(defaultOutputLocation);
        }
        IRuntimeClasspathEntry[] result = new IRuntimeClasspathEntry[outputLocations.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new RuntimeClasspathEntry(JavaCore.newLibraryEntry((IPath)((IPath)outputLocations.get(i)), null, null));
            result[i].setClasspathProperty(projectEntry.getClasspathProperty());
        }
        return result;
    }
}

