/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.util.Collection;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.GradleBuilds;
import org.eclipse.buildship.core.workspace.GradleWorkspaceManager;
import org.eclipse.buildship.core.workspace.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.workspace.internal.DefaultGradleBuilds;
import org.eclipse.core.resources.IProject;

public class DefaultGradleWorkspaceManager
implements GradleWorkspaceManager {
    private final LoadingCache<BuildConfiguration, GradleBuild> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<BuildConfiguration, GradleBuild>(){

        public GradleBuild load(BuildConfiguration buildConfiguration) {
            return new DefaultGradleBuild(buildConfiguration);
        }
    });

    @Override
    public GradleBuild getGradleBuild(FixedRequestAttributes attributes) {
        BuildConfiguration configuration = CorePlugin.configurationManager().createBuildConfiguration(attributes.getProjectDir(), false, attributes.getGradleDistribution(), attributes.getGradleUserHome(), false, false);
        return this.getGradleBuild(configuration);
    }

    @Override
    public GradleBuild getGradleBuild(BuildConfiguration buildConfig) {
        return (GradleBuild)this.cache.getUnchecked((Object)buildConfig);
    }

    @Override
    public Optional<GradleBuild> getGradleBuild(IProject project) {
        if (GradleProjectNature.isPresentOn(project)) {
            BuildConfiguration buildConfig = CorePlugin.configurationManager().loadProjectConfiguration(project).getBuildConfiguration();
            return Optional.of((Object)new DefaultGradleBuild(buildConfig));
        }
        return Optional.absent();
    }

    @Override
    public GradleBuilds getGradleBuilds() {
        return new DefaultGradleBuilds(this.getBuildConfigs((Collection<IProject>)CorePlugin.workspaceOperations().getAllProjects()));
    }

    @Override
    public GradleBuilds getGradleBuilds(Set<IProject> projects) {
        return new DefaultGradleBuilds(this.getBuildConfigs(projects));
    }

    private Set<BuildConfiguration> getBuildConfigs(Collection<IProject> projects) {
        return FluentIterable.from(projects).filter(GradleProjectNature.isPresentOn()).transform((Function)new Function<IProject, BuildConfiguration>(){

            public BuildConfiguration apply(IProject project) {
                return CorePlugin.configurationManager().loadProjectConfiguration(project).getBuildConfiguration();
            }
        }).filter(Predicates.notNull()).toSet();
    }
}

