/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.OmniEclipseSourceDirectory;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

final class SourceFolderUpdater {
    private static final String CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL = "FROM_GRADLE_MODEL";
    private final IJavaProject project;
    private final List<OmniEclipseSourceDirectory> sourceFolders;

    private SourceFolderUpdater(IJavaProject project, List<OmniEclipseSourceDirectory> sourceFolders) {
        this.project = (IJavaProject)Preconditions.checkNotNull((Object)project);
        this.sourceFolders = (List)Preconditions.checkNotNull(sourceFolders);
    }

    private void updateClasspath(IProgressMonitor monitor) throws CoreException {
        ImmutableList<IClasspathEntry> gradleSourceFolders = this.collectGradleSourceFolders();
        List<IClasspathEntry> newClasspathEntries = this.calculateNewClasspath((List<IClasspathEntry>)gradleSourceFolders);
        this.updateClasspath(newClasspathEntries, monitor);
    }

    private ImmutableList<IClasspathEntry> collectGradleSourceFolders() throws CoreException {
        ImmutableList rawClasspath = ImmutableList.copyOf((Object[])this.project.getRawClasspath());
        ImmutableList.Builder sourceFolderEntries = ImmutableList.builder();
        for (OmniEclipseSourceDirectory sourceFolder : this.sourceFolders) {
            sourceFolderEntries.add((Object)this.createSourceFolderEntry(sourceFolder, (List<IClasspathEntry>)rawClasspath));
        }
        return ImmutableSet.copyOf((Collection)sourceFolderEntries.build()).asList();
    }

    private IClasspathEntry createSourceFolderEntry(OmniEclipseSourceDirectory directory, List<IClasspathEntry> rawClasspath) throws CoreException {
        Optional<IFolder> linkedFolder = this.getLinkedFolderIfExists(directory.getDirectory());
        IFolder sourceDirectory = linkedFolder.isPresent() ? (IFolder)linkedFolder.get() : this.project.getProject().getFolder(Path.fromOSString((String)directory.getPath()));
        FileUtils.ensureFolderHierarchyExists(sourceDirectory);
        final IPackageFragmentRoot root = this.project.getPackageFragmentRoot((IResource)sourceDirectory);
        Optional currentClasspathEntry = FluentIterable.from(rawClasspath).firstMatch((Predicate)new Predicate<IClasspathEntry>(){

            public boolean apply(IClasspathEntry entry) {
                return root.getPath().equals((Object)entry.getPath());
            }
        });
        IPath[] includes = currentClasspathEntry.isPresent() ? ((IClasspathEntry)currentClasspathEntry.get()).getInclusionPatterns() : new IPath[]{};
        IPath[] excludes = currentClasspathEntry.isPresent() ? ((IClasspathEntry)currentClasspathEntry.get()).getExclusionPatterns() : new IPath[]{};
        IClasspathAttribute fromGradleModel = JavaCore.newClasspathAttribute((String)CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL, (String)"true");
        return JavaCore.newSourceEntry((IPath)root.getPath(), (IPath[])includes, (IPath[])excludes, null, (IClasspathAttribute[])new IClasspathAttribute[]{fromGradleModel});
    }

    private Optional<IFolder> getLinkedFolderIfExists(final File directory) throws CoreException {
        IResource[] children = this.project.getProject().members();
        return FluentIterable.from(Arrays.asList(children)).filter(IFolder.class).firstMatch((Predicate)new Predicate<IFolder>(){

            public boolean apply(IFolder folder) {
                return folder.isLinked() && folder.getLocation() != null && folder.getLocation().toFile().equals(directory);
            }
        });
    }

    private List<IClasspathEntry> calculateNewClasspath(List<IClasspathEntry> gradleSourceFolders) throws JavaModelException {
        ImmutableSet gradleModelSourcePaths = FluentIterable.from(gradleSourceFolders).transform((Function)new Function<IClasspathEntry, IPath>(){

            public IPath apply(IClasspathEntry entry) {
                return entry.getPath();
            }
        }).toSet();
        ImmutableList rawClasspath = ImmutableList.copyOf((Object[])this.project.getRawClasspath());
        ImmutableList manuallyAddedSourceFolders = FluentIterable.from((Iterable)rawClasspath).filter((Predicate)new Predicate<IClasspathEntry>((Set)gradleModelSourcePaths){
            final /* synthetic */ Set val$gradleModelSourcePaths;
            {
                this.val$gradleModelSourcePaths = set;
            }

            public boolean apply(IClasspathEntry entry) {
                if (this.val$gradleModelSourcePaths.contains(entry.getPath())) {
                    return false;
                }
                for (IClasspathAttribute attribute : entry.getExtraAttributes()) {
                    if (!attribute.getName().equals(SourceFolderUpdater.CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL) || !attribute.getValue().equals("true")) continue;
                    return false;
                }
                return true;
            }
        }).toList();
        return ImmutableList.builder().addAll(gradleSourceFolders).addAll((Iterable)manuallyAddedSourceFolders).build();
    }

    private void updateClasspath(List<IClasspathEntry> newClasspathEntries, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] newRawClasspath = newClasspathEntries.toArray(new IClasspathEntry[newClasspathEntries.size()]);
        this.project.setRawClasspath(newRawClasspath, monitor);
    }

    public static void update(IJavaProject project, List<OmniEclipseSourceDirectory> sourceFolders, IProgressMonitor monitor) throws CoreException {
        SourceFolderUpdater updater = new SourceFolderUpdater(project, sourceFolders);
        updater.updateClasspath(monitor);
    }
}

