/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.gradle.Specs;
import org.eclipse.buildship.core.workspace.WorkspaceGradleOperations;
import org.eclipse.buildship.core.workspace.WorkspaceOperations;
import org.eclipse.buildship.core.workspace.internal.ClasspathContainerUpdater;
import org.eclipse.buildship.core.workspace.internal.DefaultProjectCreatedEvent;
import org.eclipse.buildship.core.workspace.internal.LinkedResourcesUpdater;
import org.eclipse.buildship.core.workspace.internal.ResourceFilter;
import org.eclipse.buildship.core.workspace.internal.SourceFolderUpdater;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

public final class DefaultWorkspaceGradleOperations
implements WorkspaceGradleOperations {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachNewGradleAwareProjectOrExistingProjectToWorkspace(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes fixedAttributes, List<String> workingSets, IProgressMonitor monitor) {
        monitor.beginTask("Attach Gradle project " + project.getName(), 3);
        try {
            IProject workspaceProject;
            WorkspaceOperations workspaceOperations = CorePlugin.workspaceOperations();
            File projectDirectory = project.getProjectDirectory();
            Optional<IProjectDescription> projectDescription = workspaceOperations.findProjectInFolder(projectDirectory, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ImmutableList filteredSubFolders = ImmutableList.builder().addAll(this.collectChildProjectLocations(project)).add((Object)this.getBuildDirectory(gradleBuild, project)).add((Object)this.getDotGradleDirectory(project)).build();
            ImmutableList gradleNature = ImmutableList.of((Object)"org.eclipse.buildship.core.gradleprojectnature");
            if (projectDescription.isPresent()) {
                workspaceProject = workspaceOperations.includeProject((IProjectDescription)projectDescription.get(), (List<File>)filteredSubFolders, (List<String>)gradleNature, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            } else {
                workspaceProject = workspaceOperations.createProject(project.getName(), project.getProjectDirectory(), (List<File>)filteredSubFolders, (List<String>)gradleNature, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (this.isJavaProject(project)) {
                    IPath jrePath = JavaRuntime.getDefaultJREContainerEntry().getPath();
                    workspaceOperations.createJavaProject(workspaceProject, jrePath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
            }
            ProjectConfiguration projectConfiguration = ProjectConfiguration.from(fixedAttributes, project);
            CorePlugin.projectConfigurationManager().saveProjectConfiguration(projectConfiguration, workspaceProject);
            DefaultProjectCreatedEvent event = new DefaultProjectCreatedEvent(workspaceProject, workingSets);
            CorePlugin.listenerRegistry().dispatch(event);
        }
        finally {
            monitor.done();
        }
    }

    private List<File> collectChildProjectLocations(OmniEclipseProject project) {
        return FluentIterable.from((Iterable)project.getChildren()).transform((Function)new Function<OmniEclipseProject, File>(){

            public File apply(OmniEclipseProject project) {
                return project.getProjectDirectory();
            }
        }).toList();
    }

    private File getBuildDirectory(OmniEclipseGradleBuild eclipseGradleBuild, OmniEclipseProject project) {
        Optional gradleProject = eclipseGradleBuild.getRootProject().tryFind(Specs.gradleProjectMatchesProjectPath(project.getPath()));
        Maybe buildScript = ((OmniGradleProject)gradleProject.get()).getBuildDirectory();
        if (buildScript.isPresent() && buildScript.get() != null) {
            return (File)buildScript.get();
        }
        return new File(project.getProjectDirectory(), "build");
    }

    private File getDotGradleDirectory(OmniEclipseProject project) {
        return new File(project.getProjectDirectory(), ".gradle");
    }

    private boolean isJavaProject(OmniEclipseProject project) {
        return !project.getSourceDirectories().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeProjectGradleUnaware(IProject workspaceProject, IProgressMonitor monitor) {
        monitor.beginTask("Detach Gradle specifics from project " + workspaceProject.getName(), 2);
        try {
            CorePlugin.workspaceOperations().removeNature(workspaceProject, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CorePlugin.projectConfigurationManager().deleteProjectConfiguration(workspaceProject);
            ResourceFilter.detachAllFilters(workspaceProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void updateProjectInWorkspace(IProject workspaceProject, OmniEclipseProject project, IProgressMonitor monitor) {
        monitor.beginTask("Update Gradle project " + project.getName(), 3);
        try {
            LinkedResourcesUpdater.update(workspaceProject, project.getLinkedResources(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.hasJavaNature(workspaceProject)) {
                IJavaProject javaProject = JavaCore.create((IProject)workspaceProject);
                SourceFolderUpdater.update(javaProject, project.getSourceDirectories(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ClasspathContainerUpdater.update(javaProject, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(2);
            }
        }
        catch (CoreException e) {
            String message = String.format("Cannot update project %s.", workspaceProject);
            CorePlugin.logger().error(message, e);
            throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
        }
        finally {
            monitor.done();
        }
    }

    private boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            return false;
        }
    }
}

