/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProvider;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.util.predicate.Predicates;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public final class RefreshGradleProjectJob
extends ToolingApiWorkspaceJob {
    private final FixedRequestAttributes rootRequestAttributes;

    public RefreshGradleProjectJob(FixedRequestAttributes rootRequestAttributes) {
        super("Reload root project at " + ((FixedRequestAttributes)Preconditions.checkNotNull((Object)rootRequestAttributes)).getProjectDir().getAbsolutePath(), false);
        this.rootRequestAttributes = rootRequestAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runToolingApiJobInWorkspace(IProgressMonitor monitor) {
        monitor.beginTask("Refresh Gradle project and Eclipse workspace", 100);
        IJobManager manager = Job.getJobManager();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        manager.beginRule((ISchedulingRule)workspaceRoot, monitor);
        try {
            OmniEclipseGradleBuild result = this.forceReloadEclipseGradleBuild(this.rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            this.synchronizeGradleProjectsWithWorkspace(result, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        finally {
            manager.endRule((ISchedulingRule)workspaceRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OmniEclipseGradleBuild forceReloadEclipseGradleBuild(FixedRequestAttributes requestAttributes, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Force reload of Gradle build located at %s", requestAttributes.getProjectDir().getAbsolutePath()), -1);
        try {
            ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
            ImmutableList listeners = ImmutableList.of((Object)new DelegatingProgressListener(monitor));
            TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), streams.getInput(), (List)listeners, (List)ImmutableList.of(), this.getToken());
            ModelRepositoryProvider repository = CorePlugin.modelRepositoryProvider();
            OmniEclipseGradleBuild omniEclipseGradleBuild = repository.getModelRepository(requestAttributes).fetchEclipseGradleBuild(transientAttributes, FetchStrategy.FORCE_RELOAD);
            return omniEclipseGradleBuild;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeGradleProjectsWithWorkspace(OmniEclipseGradleBuild gradleBuild, IProgressMonitor monitor) {
        List allGradleProjects = gradleBuild.getRootEclipseProject().getAll();
        List<IProject> oldWorkspaceProjects = this.collectWorkspaceProjectsRemovedFromGradleBuild(allGradleProjects);
        List<OmniEclipseProject> newGradleProjects = this.collectGradleProjectsNotPresentInWorkspace(allGradleProjects);
        monitor.beginTask("Synchronize Gradle projects with workspace", oldWorkspaceProjects.size() + allGradleProjects.size());
        try {
            for (IProject oldProject : oldWorkspaceProjects) {
                this.removeProject(oldProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            for (OmniEclipseProject gradleProject : allGradleProjects) {
                if (newGradleProjects.contains(gradleProject)) {
                    this.addProject(gradleProject, gradleBuild, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    continue;
                }
                this.updateProject(gradleProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private List<IProject> collectWorkspaceProjectsRemovedFromGradleBuild(List<OmniEclipseProject> gradleProjects) {
        ImmutableSet gradleProjectDirectories = FluentIterable.from(gradleProjects).transform((Function)new Function<OmniEclipseProject, File>(){

            public File apply(OmniEclipseProject gradleProject) {
                return gradleProject.getProjectDirectory();
            }
        }).toSet();
        ImmutableList<IProject> allWorkspaceProjects = CorePlugin.workspaceOperations().getAllProjects();
        return FluentIterable.from(allWorkspaceProjects).filter(Predicates.accessibleGradleProject()).filter((Predicate)new Predicate<IProject>((Set)gradleProjectDirectories){
            final /* synthetic */ Set val$gradleProjectDirectories;
            {
                this.val$gradleProjectDirectories = set;
            }

            public boolean apply(IProject project) {
                ProjectConfiguration projectConfiguration = CorePlugin.projectConfigurationManager().readProjectConfiguration(project);
                return projectConfiguration.getRequestAttributes().getProjectDir().equals(RefreshGradleProjectJob.this.rootRequestAttributes.getProjectDir()) && project.getLocation() != null && !this.val$gradleProjectDirectories.contains(project.getLocation().toFile());
            }
        }).toList();
    }

    private List<OmniEclipseProject> collectGradleProjectsNotPresentInWorkspace(List<OmniEclipseProject> gradleProjects) {
        return FluentIterable.from(gradleProjects).filter((Predicate)new Predicate<OmniEclipseProject>(){

            public boolean apply(OmniEclipseProject gradleProject) {
                Optional<IProject> workspaceProject = CorePlugin.workspaceOperations().findProjectByLocation(gradleProject.getProjectDirectory());
                return !workspaceProject.isPresent();
            }
        }).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProject(IProject project, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Remove project %s", project.getName()), 1);
        try {
            CorePlugin.workspaceGradleOperations().makeProjectGradleUnaware(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProject(OmniEclipseProject gradleProject, OmniEclipseGradleBuild eclipseGradleBuild, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Add project %s", gradleProject.getName()), 1);
        try {
            CorePlugin.workspaceGradleOperations().attachNewGradleAwareProjectOrExistingProjectToWorkspace(gradleProject, eclipseGradleBuild, this.rootRequestAttributes, (List<String>)ImmutableList.of(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProject(OmniEclipseProject gradleProject, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Add project %s", gradleProject.getName()), 1);
        try {
            IProject project = (IProject)CorePlugin.workspaceOperations().findProjectByLocation(gradleProject.getProjectDirectory()).get();
            if (project.isAccessible()) {
                if (!GradleProjectNature.INSTANCE.isPresentOn(project)) {
                    CorePlugin.workspaceOperations().addNature(project, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)new NullProgressMonitor());
                    ProjectConfiguration configuration = ProjectConfiguration.from(this.rootRequestAttributes, gradleProject);
                    CorePlugin.projectConfigurationManager().saveProjectConfiguration(configuration, project);
                }
                CorePlugin.workspaceGradleOperations().updateProjectInWorkspace(project, gradleProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean belongsTo(Object family) {
        return RefreshGradleProjectJob.class.getName().equals(family);
    }
}

