/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.projectimport;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public final class ProjectImportJob
extends ToolingApiWorkspaceJob {
    private final FixedRequestAttributes fixedAttributes;
    private final ImmutableList<String> workingSets;
    private final AsyncHandler initializer;

    public ProjectImportJob(ProjectImportConfiguration configuration, AsyncHandler initializer) {
        super("Importing Gradle project");
        this.fixedAttributes = configuration.toFixedAttributes();
        this.workingSets = (Boolean)configuration.getApplyWorkingSets().getValue() != false ? ImmutableList.copyOf((Collection)((Collection)configuration.getWorkingSets().getValue())) : ImmutableList.of();
        this.initializer = (AsyncHandler)Preconditions.checkNotNull((Object)initializer);
        this.setUser(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runToolingApiJobInWorkspace(IProgressMonitor monitor) {
        monitor.beginTask("Import Gradle project", 100);
        this.initializer.run((IProgressMonitor)new SubProgressMonitor(monitor, 10), this.getToken());
        IJobManager manager = Job.getJobManager();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        manager.beginRule((ISchedulingRule)workspaceRoot, monitor);
        try {
            OmniEclipseGradleBuild eclipseGradleBuild = this.fetchEclipseGradleBuild((IProgressMonitor)new SubProgressMonitor(monitor, 40));
            OmniEclipseProject rootProject = eclipseGradleBuild.getRootEclipseProject();
            List allProjects = rootProject.getAll();
            for (OmniEclipseProject project : allProjects) {
                CorePlugin.workspaceGradleOperations().attachNewGradleAwareProjectOrExistingProjectToWorkspace(project, eclipseGradleBuild, this.fixedAttributes, (List<String>)this.workingSets, (IProgressMonitor)new SubProgressMonitor(monitor, 50 / allProjects.size()));
            }
        }
        finally {
            manager.endRule((ISchedulingRule)workspaceRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OmniEclipseGradleBuild fetchEclipseGradleBuild(IProgressMonitor monitor) {
        monitor.beginTask("Load Eclipse Gradle project", -1);
        try {
            ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
            ImmutableList listeners = ImmutableList.of((Object)new DelegatingProgressListener(monitor));
            TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), null, (List)listeners, (List)ImmutableList.of(), this.getToken());
            ModelRepository repository = CorePlugin.modelRepositoryProvider().getModelRepository(this.fixedAttributes);
            OmniEclipseGradleBuild omniEclipseGradleBuild = repository.fetchEclipseGradleBuild(transientAttributes, FetchStrategy.FORCE_RELOAD);
            return omniEclipseGradleBuild;
        }
        finally {
            monitor.done();
        }
    }
}

