/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.gradleware.tooling.toolingmodel.OmniClasspathAttribute;
import com.gradleware.tooling.toolingmodel.OmniEclipseSourceDirectory;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

final class SourceFolderUpdater {
    private static final String CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL = "FROM_GRADLE_MODEL";
    private final IJavaProject project;
    private final List<OmniEclipseSourceDirectory> sourceFolders;

    private SourceFolderUpdater(IJavaProject project, List<OmniEclipseSourceDirectory> sourceFolders) {
        this.project = (IJavaProject)Preconditions.checkNotNull((Object)project);
        this.sourceFolders = (List)Preconditions.checkNotNull(sourceFolders);
    }

    private void updateClasspath(IProgressMonitor monitor) throws CoreException {
        ImmutableList<IClasspathEntry> gradleSourceFolders = this.collectGradleSourceFolders();
        List<IClasspathEntry> newClasspathEntries = this.calculateNewClasspath((List<IClasspathEntry>)gradleSourceFolders);
        this.updateClasspath(newClasspathEntries, monitor);
    }

    private ImmutableList<IClasspathEntry> collectGradleSourceFolders() throws CoreException {
        HashMap sourceFolders = Maps.newHashMap();
        for (IClasspathEntry iClasspathEntry : this.project.getRawClasspath()) {
            if (iClasspathEntry.getEntryKind() != 3) continue;
            sourceFolders.put(iClasspathEntry.getPath(), iClasspathEntry);
        }
        ImmutableList.Builder sourceFolderEntries = ImmutableList.builder();
        for (OmniEclipseSourceDirectory sourceFolder : this.sourceFolders) {
            Optional<IClasspathEntry> optional = this.createSourceFolderEntry(sourceFolder, sourceFolders);
            if (!optional.isPresent()) continue;
            sourceFolderEntries.add(optional.get());
        }
        return ImmutableSet.copyOf((Collection)sourceFolderEntries.build()).asList();
    }

    private Optional<IClasspathEntry> createSourceFolderEntry(OmniEclipseSourceDirectory directory, Map<IPath, IClasspathEntry> sourceFolders) throws CoreException {
        Optional includes;
        Optional excludes;
        Optional attributes;
        Maybe output;
        IResource sourceDirectory;
        Optional<IFolder> linkedFolder = this.getLinkedFolderIfExists(directory.getDirectory());
        IResource iResource = sourceDirectory = linkedFolder.isPresent() ? (IResource)linkedFolder.get() : this.getFolderOrProjectRoot(directory);
        if (!sourceDirectory.exists()) {
            return Optional.absent();
        }
        IPackageFragmentRoot root = this.project.getPackageFragmentRoot(sourceDirectory);
        SourceFolderEntryBuilder builder = new SourceFolderEntryBuilder(this.project, root.getPath());
        IClasspathEntry existingEntry = sourceFolders.get(root.getPath());
        if (existingEntry != null) {
            builder.setOutput(existingEntry.getOutputLocation());
            builder.setAttributes(existingEntry.getExtraAttributes());
            builder.setIncludes(existingEntry.getInclusionPatterns());
            builder.setExcludes(existingEntry.getExclusionPatterns());
        }
        if ((output = directory.getOutput()).isPresent()) {
            builder.setOutput((String)output.get());
        }
        if ((attributes = directory.getClasspathAttributes()).isPresent()) {
            builder.setAttributes((List)attributes.get());
        }
        if ((excludes = directory.getExcludes()).isPresent()) {
            builder.setExcludes((List)excludes.get());
        }
        if ((includes = directory.getIncludes()).isPresent()) {
            builder.setIncludes((List)includes.get());
        }
        builder.addAttribute(CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL, "true");
        return Optional.of((Object)builder.build());
    }

    private IResource getFolderOrProjectRoot(OmniEclipseSourceDirectory directory) {
        IProject project = this.project.getProject();
        IPath path = project.getFullPath().append(directory.getPath());
        if (path.segmentCount() == 1) {
            return project;
        }
        return project.getFolder(path.removeFirstSegments(1));
    }

    private Optional<IFolder> getLinkedFolderIfExists(final File directory) throws CoreException {
        IResource[] children = this.project.getProject().members();
        return FluentIterable.from(Arrays.asList(children)).filter(IFolder.class).firstMatch((Predicate)new Predicate<IFolder>(){

            public boolean apply(IFolder folder) {
                return folder.isLinked() && folder.getLocation() != null && folder.getLocation().toFile().equals(directory);
            }
        });
    }

    private List<IClasspathEntry> calculateNewClasspath(List<IClasspathEntry> gradleSourceFolders) throws JavaModelException {
        ImmutableSet gradleModelSourcePaths = FluentIterable.from(gradleSourceFolders).transform((Function)new Function<IClasspathEntry, IPath>(){

            public IPath apply(IClasspathEntry entry) {
                return entry.getPath();
            }
        }).toSet();
        ImmutableList rawClasspath = ImmutableList.copyOf((Object[])this.project.getRawClasspath());
        ImmutableList manuallyAddedSourceFolders = FluentIterable.from((Iterable)rawClasspath).filter((Predicate)new Predicate<IClasspathEntry>((Set)gradleModelSourcePaths){
            final /* synthetic */ Set val$gradleModelSourcePaths;
            {
                this.val$gradleModelSourcePaths = set;
            }

            public boolean apply(IClasspathEntry entry) {
                if (entry.getEntryKind() != 3) {
                    return true;
                }
                if (SourceFolderUpdater.this.isDefaultClasspathEntry(entry)) {
                    return false;
                }
                if (this.val$gradleModelSourcePaths.contains(entry.getPath())) {
                    return false;
                }
                for (IClasspathAttribute attribute : entry.getExtraAttributes()) {
                    if (!attribute.getName().equals(SourceFolderUpdater.CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL) || !attribute.getValue().equals("true")) continue;
                    return false;
                }
                return true;
            }
        }).toList();
        return ImmutableList.builder().addAll(gradleSourceFolders).addAll((Iterable)manuallyAddedSourceFolders).build();
    }

    private void updateClasspath(List<IClasspathEntry> newClasspathEntries, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] newRawClasspath = newClasspathEntries.toArray(new IClasspathEntry[newClasspathEntries.size()]);
        this.project.setRawClasspath(newRawClasspath, monitor);
    }

    private boolean isDefaultClasspathEntry(IClasspathEntry entry) {
        return entry.getPath().equals((Object)this.project.getPath()) && entry.getExclusionPatterns().length == 0 && entry.getInclusionPatterns().length == 0 && entry.getExtraAttributes().length == 0;
    }

    public static void update(IJavaProject project, List<OmniEclipseSourceDirectory> sourceFolders, IProgressMonitor monitor) throws CoreException {
        SourceFolderUpdater updater = new SourceFolderUpdater(project, sourceFolders);
        updater.updateClasspath(monitor);
    }

    private static class SourceFolderEntryBuilder {
        private final IPath path;
        private final IJavaProject project;
        private IPath output = null;
        private List<String> includes = new ArrayList<String>();
        private List<String> excludes = new ArrayList<String>();
        private Map<String, String> attributes = new LinkedHashMap<String, String>();

        public SourceFolderEntryBuilder(IJavaProject project, IPath path) {
            this.project = project;
            this.path = path;
        }

        public void setOutput(IPath output) {
            this.output = output;
        }

        public void setOutput(String output) {
            this.output = output == null ? null : this.project.getPath().append(output);
        }

        public void setIncludes(IPath[] includes) {
            this.setIncludes(SourceFolderEntryBuilder.pathsToStringList(includes));
        }

        public void setIncludes(List<String> includes) {
            this.includes = includes;
        }

        public void setExcludes(IPath[] excludes) {
            this.setExcludes(SourceFolderEntryBuilder.pathsToStringList(excludes));
        }

        public void setExcludes(List<String> excludes) {
            this.excludes = excludes;
        }

        public void setAttributes(IClasspathAttribute[] attributes) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (IClasspathAttribute attr : attributes) {
                result.put(attr.getName(), attr.getValue());
            }
            this.attributes = result;
        }

        public void setAttributes(List<OmniClasspathAttribute> attributes) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (OmniClasspathAttribute attr : attributes) {
                result.put(attr.getName(), attr.getValue());
            }
            this.attributes = result;
        }

        public void addAttribute(String name, String value) {
            this.attributes.put(name, value);
        }

        public IClasspathEntry build() {
            return JavaCore.newSourceEntry((IPath)this.path, (IPath[])this.getIncludes(), (IPath[])this.getExcludes(), (IPath)this.getOutput(), (IClasspathAttribute[])this.getAttributes());
        }

        private IPath getOutput() {
            return this.output;
        }

        private IPath[] getIncludes() {
            return SourceFolderEntryBuilder.stringListToPaths(this.includes);
        }

        private IPath[] getExcludes() {
            return SourceFolderEntryBuilder.stringListToPaths(this.excludes);
        }

        private IClasspathAttribute[] getAttributes() {
            return (IClasspathAttribute[])FluentIterable.from(this.attributes.entrySet()).transform((Function)new Function<Map.Entry<String, String>, IClasspathAttribute>(){

                public IClasspathAttribute apply(Map.Entry<String, String> entry) {
                    return JavaCore.newClasspathAttribute((String)entry.getKey(), (String)entry.getValue());
                }
            }).toArray(IClasspathAttribute.class);
        }

        private static List<String> pathsToStringList(IPath[] paths) {
            ArrayList<String> result = new ArrayList<String>();
            for (IPath path : paths) {
                result.add(path.toPortableString());
            }
            return result;
        }

        private static IPath[] stringListToPaths(List<String> strings) {
            IPath[] result = new IPath[strings.size()];
            for (int i = 0; i < strings.size(); ++i) {
                result[i] = new Path(strings.get(i));
            }
            return result;
        }
    }
}

