/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.File;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.UnknownModelException;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.connection.DefaultProjectIdentifier;
import org.gradle.tooling.internal.consumer.converters.FixedBuildIdentifierProvider;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.HasGradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.internal.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildControllerAdapter
implements BuildController {
    private final InternalBuildController buildController;
    private final ProtocolToModelAdapter adapter;
    private final ModelMapping modelMapping;
    private final File rootDir;

    public BuildControllerAdapter(ProtocolToModelAdapter adapter, InternalBuildController buildController, ModelMapping modelMapping, File rootDir) {
        this.adapter = adapter;
        this.buildController = buildController;
        this.modelMapping = modelMapping;
        this.rootDir = rootDir;
    }

    @Override
    public <T> T getModel(Class<T> modelType) throws UnknownModelException {
        return this.getModel(null, modelType);
    }

    @Override
    public <T> T findModel(Class<T> modelType) {
        try {
            return this.getModel(modelType);
        }
        catch (UnknownModelException e) {
            return null;
        }
    }

    @Override
    public GradleBuild getBuildModel() {
        return this.getModel(null, GradleBuild.class);
    }

    @Override
    public <T> T findModel(Model target, Class<T> modelType) {
        try {
            return this.getModel(target, modelType);
        }
        catch (UnknownModelException e) {
            return null;
        }
    }

    @Override
    public <T> T getModel(Model target, Class<T> modelType) throws UnknownModelException {
        BuildResult<?> result;
        ModelIdentifier modelIdentifier = this.modelMapping.getModelIdentifierFromModelType(modelType);
        Object originalTarget = target == null ? null : this.adapter.unpack(target);
        try {
            result = this.buildController.getModel(originalTarget, modelIdentifier);
        }
        catch (InternalUnsupportedModelException e) {
            throw Exceptions.unknownModel(modelType, e);
        }
        if (this.rootDir != null) {
            DefaultProjectIdentifier projectIdentifier = new DefaultProjectIdentifier(this.rootDir, this.getProjectPath(target));
            return this.adapter.adapt(modelType, result.getModel(), new FixedBuildIdentifierProvider(projectIdentifier));
        }
        return this.adapter.adapt(modelType, result.getModel());
    }

    private String getProjectPath(Model target) {
        if (target instanceof GradleProject) {
            return ((GradleProject)target).getPath();
        }
        if (target instanceof BasicGradleProject) {
            return ((BasicGradleProject)target).getPath();
        }
        if (target instanceof HasGradleProject) {
            return ((HasGradleProject)((Object)target)).getGradleProject().getPath();
        }
        return ":";
    }
}

