/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.util.gradle;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.eclipse.buildship.core.FixedVersionGradleDistribution;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.LocalGradleDistribution;
import org.eclipse.buildship.core.RemoteGradleDistribution;
import org.eclipse.buildship.core.WrapperGradleDistribution;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.core.internal.util.binding.Validator;
import org.eclipse.osgi.util.NLS;

public final class GradleDistributionViewModel {
    private static final int INVALID_TYPE_ID = Type.values().length;
    private final int typeId;
    private final String configuration;

    public GradleDistributionViewModel(Type type, String configuration) {
        this.typeId = type != null ? type.ordinal() : INVALID_TYPE_ID;
        this.configuration = Strings.nullToEmpty((String)configuration);
    }

    public Optional<Type> getType() {
        if (this.typeId == INVALID_TYPE_ID) {
            return Optional.empty();
        }
        return Optional.of(Type.values()[this.typeId]);
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public boolean isValid() {
        return !this.validate().isPresent();
    }

    public com.google.common.base.Optional<String> validate() {
        Optional<Type> typeOrNull = this.getType();
        if (!typeOrNull.isPresent()) {
            return com.google.common.base.Optional.of((Object)"Invalid distribution type");
        }
        Type type = typeOrNull.get();
        if (type == Type.LOCAL_INSTALLATION) {
            if (Strings.isNullOrEmpty((String)this.configuration)) {
                return com.google.common.base.Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeSpecified, (Object)CoreMessages.GradleDistribution_Label_LocalInstallationDirectory));
            }
            return GradleDistributionViewModel.validateLocalInstallationLocation(new File(this.configuration));
        }
        if (type == Type.REMOTE_DISTRIBUTION) {
            if (Strings.isNullOrEmpty((String)this.configuration)) {
                return com.google.common.base.Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeSpecified, (Object)CoreMessages.GradleDistribution_Label_RemoteDistributionUri));
            }
            if (!this.isValidURI(this.configuration)) {
                return com.google.common.base.Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_IsNotValid, (Object)CoreMessages.GradleDistribution_Label_RemoteDistributionUri));
            }
            return com.google.common.base.Optional.absent();
        }
        if (type == Type.VERSION) {
            if (Strings.isNullOrEmpty((String)this.configuration)) {
                return com.google.common.base.Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeSpecified, (Object)CoreMessages.GradleDistribution_Label_SpecificGradleVersion));
            }
            return com.google.common.base.Optional.absent();
        }
        return com.google.common.base.Optional.absent();
    }

    private static com.google.common.base.Optional<String> validateLocalInstallationLocation(File location) {
        if (location == null) {
            return com.google.common.base.Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeSpecified, (Object)CoreMessages.GradleDistribution_Label_LocalInstallationDirectory));
        }
        if (!location.exists()) {
            return com.google.common.base.Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_DoesNotExist, (Object)CoreMessages.GradleDistribution_Label_LocalInstallationDirectory));
        }
        if (!location.isDirectory()) {
            return com.google.common.base.Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeDirectory, (Object)CoreMessages.GradleDistribution_Label_LocalInstallationDirectory));
        }
        return com.google.common.base.Optional.absent();
    }

    private boolean isValidURI(String configuration) {
        try {
            new URI(configuration);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public GradleDistribution toGradleDistribution() {
        com.google.common.base.Optional<String> errorMessage = this.validate();
        if (errorMessage.isPresent()) {
            throw new GradlePluginsRuntimeException((String)errorMessage.get());
        }
        switch (this.getType().get()) {
            case WRAPPER: {
                return GradleDistribution.fromBuild();
            }
            case LOCAL_INSTALLATION: {
                return GradleDistribution.forLocalInstallation((File)new File(this.configuration));
            }
            case REMOTE_DISTRIBUTION: {
                return GradleDistribution.forRemoteDistribution((URI)GradleDistributionViewModel.createUrl(this.configuration));
            }
            case VERSION: {
                return GradleDistribution.forVersion((String)this.configuration);
            }
        }
        throw new GradlePluginsRuntimeException("Invalid distribution type: " + (Object)((Object)this.getType().get()));
    }

    private static URI createUrl(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new GradlePluginsRuntimeException((Throwable)e);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GradleDistributionViewModel that = (GradleDistributionViewModel)other;
        return Objects.equal((Object)this.typeId, (Object)that.typeId) && Objects.equal((Object)this.configuration, (Object)that.configuration);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.typeId, this.configuration});
    }

    public String toString() {
        Optional<Type> typeOrNull = this.getType();
        if (!typeOrNull.isPresent()) {
            return "Unknown Gradle distribution " + this.configuration;
        }
        Type type = typeOrNull.get();
        switch (type) {
            case WRAPPER: {
                return CoreMessages.GradleDistribution_Value_UseGradleWrapper;
            }
            case LOCAL_INSTALLATION: {
                return NLS.bind((String)CoreMessages.GradleDistribution_Value_UseLocalInstallation_0, (Object)this.configuration);
            }
            case REMOTE_DISTRIBUTION: {
                return NLS.bind((String)CoreMessages.GradleDistribution_Value_UseRemoteDistribution_0, (Object)this.configuration);
            }
            case VERSION: {
                return NLS.bind((String)CoreMessages.GradleDistribution_Value_UseGradleVersion_0, (Object)this.configuration);
            }
        }
        throw new GradlePluginsRuntimeException("Unrecognized Gradle distribution type: " + (Object)((Object)type));
    }

    public static GradleDistributionViewModel from(GradleDistribution gradleDistribution) {
        if (gradleDistribution instanceof LocalGradleDistribution) {
            return new GradleDistributionViewModel(Type.LOCAL_INSTALLATION, ((LocalGradleDistribution)gradleDistribution).getLocation().getAbsolutePath());
        }
        if (gradleDistribution instanceof RemoteGradleDistribution) {
            return new GradleDistributionViewModel(Type.REMOTE_DISTRIBUTION, ((RemoteGradleDistribution)gradleDistribution).getUrl().toString());
        }
        if (gradleDistribution instanceof FixedVersionGradleDistribution) {
            return new GradleDistributionViewModel(Type.VERSION, ((FixedVersionGradleDistribution)gradleDistribution).getVersion());
        }
        if (gradleDistribution instanceof WrapperGradleDistribution) {
            return new GradleDistributionViewModel(Type.WRAPPER, null);
        }
        throw new GradlePluginsRuntimeException("Invalid distribution type: " + gradleDistribution);
    }

    public static Validator<GradleDistributionViewModel> validator() {
        return new Validator<GradleDistributionViewModel>(){

            public com.google.common.base.Optional<String> validate(GradleDistributionViewModel distributionInfo) {
                return distributionInfo.validate();
            }
        };
    }

    public static enum Type {
        WRAPPER,
        LOCAL_INSTALLATION,
        REMOTE_DISTRIBUTION,
        VERSION;

    }
}

