/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.console;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

public final class GradleConsole
extends IOConsole
implements ProcessStreams {
    private final Optional<ProcessDescription> processDescription;
    private final IOConsoleOutputStream configurationStream;
    private final IOConsoleOutputStream outputStream;
    private final IOConsoleOutputStream errorStream;
    private final IOConsoleInputStream inputStream;

    public GradleConsole(String name) {
        this(name, (Optional<ProcessDescription>)Optional.absent());
    }

    public GradleConsole(ProcessDescription processDescription) {
        this(processDescription.getName(), (Optional<ProcessDescription>)Optional.of((Object)processDescription));
    }

    private GradleConsole(String name, Optional<ProcessDescription> processDescription) {
        super(name, PluginImages.TASK.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.processDescription = processDescription;
        this.configurationStream = this.newOutputStream();
        this.outputStream = this.newOutputStream();
        this.errorStream = this.newOutputStream();
        this.inputStream = super.getInputStream();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Font consoleFont = JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont");
                GradleConsole.this.setFont(consoleFont);
                Color backgroundColor = DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.consoleBackground");
                GradleConsole.this.setBackground(backgroundColor);
                Color inputColor = DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.inColor");
                GradleConsole.this.inputStream.setColor(inputColor);
                Color outputColor = DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.outColor");
                GradleConsole.this.outputStream.setColor(outputColor);
                Color errorColor = DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.errorColor");
                GradleConsole.this.errorStream.setColor(errorColor);
                Color configurationColor = PlatformUI.getWorkbench().getDisplay().getSystemColor(16);
                GradleConsole.this.configurationStream.setColor(configurationColor);
            }
        });
    }

    public Optional<ProcessDescription> getProcessDescription() {
        return this.processDescription;
    }

    public boolean isTerminated() {
        return this.processDescription.isPresent() && ((ProcessDescription)this.processDescription.get()).getJob().getState() == 0;
    }

    public boolean isCloseable() {
        return this.processDescription.isPresent();
    }

    public OutputStream getConfiguration() {
        return this.configurationStream;
    }

    public OutputStream getOutput() {
        return this.outputStream;
    }

    public OutputStream getError() {
        return this.errorStream;
    }

    public InputStream getInput() {
        return this.inputStream;
    }

    public void close() {
        IOException e = null;
        try {
            this.configurationStream.flush();
            this.configurationStream.close();
        }
        catch (IOException ioe) {
            e = ioe;
        }
        try {
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException ioe) {
            e = ioe;
        }
        try {
            this.errorStream.flush();
            this.errorStream.close();
        }
        catch (IOException ioe) {
            e = ioe;
        }
        try {
            this.inputStream.close();
        }
        catch (IOException ioe) {
            e = ioe;
        }
        if (e != null) {
            String message = String.format("Cannot close streams of console %s.", this.getName());
            UiPlugin.logger().error(message, (Throwable)e);
            throw new GradlePluginsRuntimeException(message, (Throwable)e);
        }
    }
}

