/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.preferences.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;

public final class DefaultPersistentModel
implements PersistentModel {
    private final IProject project;
    private final IPath buildDir;
    private final Collection<IPath> subprojectPaths;
    private final List<IClasspathEntry> classpath;
    private final Collection<IPath> derivedResources;
    private final Collection<IPath> linkedResources;

    public DefaultPersistentModel(IProject project, IPath buildDir, Collection<IPath> subprojectPaths, List<IClasspathEntry> classpath, Collection<IPath> derivedResources, Collection<IPath> linkedResources) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.buildDir = (IPath)Preconditions.checkNotNull((Object)buildDir);
        this.subprojectPaths = ImmutableList.copyOf(subprojectPaths);
        this.classpath = ImmutableList.copyOf(classpath);
        this.derivedResources = ImmutableList.copyOf(derivedResources);
        this.linkedResources = ImmutableList.copyOf(linkedResources);
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IPath getBuildDir() {
        return this.buildDir;
    }

    @Override
    public Collection<IPath> getSubprojectPaths() {
        return this.subprojectPaths;
    }

    @Override
    public List<IClasspathEntry> getClasspath() {
        return this.classpath;
    }

    @Override
    public Collection<IPath> getDerivedResources() {
        return this.derivedResources;
    }

    @Override
    public Collection<IPath> getLinkedResources() {
        return this.linkedResources;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultPersistentModel)) {
            return false;
        }
        DefaultPersistentModel that = (DefaultPersistentModel)obj;
        return Objects.equal((Object)this.project, (Object)that.project) && Objects.equal((Object)this.buildDir, (Object)that.buildDir) && Objects.equal(this.subprojectPaths, that.subprojectPaths) && Objects.equal(this.classpath, that.classpath) && Objects.equal(this.derivedResources, that.derivedResources) && Objects.equal(this.linkedResources, that.linkedResources);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.project, this.buildDir, this.subprojectPaths, this.classpath, this.derivedResources, this.linkedResources});
    }
}

