/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.GradleBuilds;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.workspace.internal.SynchronizeGradleBuildsJob;

public class DefaultGradleBuilds
implements GradleBuilds {
    private final ImmutableSet<GradleBuild> gradleBuilds;

    public DefaultGradleBuilds(Set<FixedRequestAttributes> attributes) {
        ImmutableSet.Builder builds = ImmutableSet.builder();
        for (FixedRequestAttributes attribute : attributes) {
            builds.add((Object)new DefaultGradleBuild(attribute));
        }
        this.gradleBuilds = builds.build();
    }

    @Override
    public void synchronize(NewProjectHandler newProjectHandler) {
        SynchronizeGradleBuildsJob.forMultipleGradleBuilds(this, newProjectHandler, AsyncHandler.NO_OP).schedule();
    }

    @Override
    public Iterator<GradleBuild> iterator() {
        return ImmutableSet.copyOf(this.getGradleBuilds()).iterator();
    }

    public ImmutableSet<GradleBuild> getGradleBuilds() {
        return this.gradleBuilds;
    }
}

