/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.configuration.ProjectConfigurationManager;
import org.eclipse.buildship.core.configuration.internal.DefaultProjectConfigurationPersistence;
import org.eclipse.buildship.core.configuration.internal.ProjectConfigurationPersistence;
import org.eclipse.buildship.core.workspace.WorkspaceOperations;
import org.eclipse.core.resources.IProject;

public final class DefaultProjectConfigurationManager
implements ProjectConfigurationManager {
    private final WorkspaceOperations workspaceOperations;
    private final ProjectConfigurationPersistence projectConfigurationPersistence;

    public DefaultProjectConfigurationManager(WorkspaceOperations workspaceOperations) {
        this.workspaceOperations = workspaceOperations;
        this.projectConfigurationPersistence = new DefaultProjectConfigurationPersistence();
    }

    @Override
    public ImmutableSet<ProjectConfiguration> getRootProjectConfigurations() {
        ImmutableSet.Builder rootConfigurations = ImmutableSet.builder();
        for (IProject workspaceProject : this.workspaceOperations.getAllProjects()) {
            Optional<ProjectConfiguration> projectConfiguration;
            if (!GradleProjectNature.isPresentOn(workspaceProject) || !(projectConfiguration = this.tryReadProjectConfiguration(workspaceProject)).isPresent()) continue;
            ProjectConfiguration rootProjectConfiguration = ProjectConfiguration.from(((ProjectConfiguration)projectConfiguration.get()).getRootProjectDirectory(), ((ProjectConfiguration)projectConfiguration.get()).getGradleDistribution());
            rootConfigurations.add((Object)rootProjectConfiguration);
        }
        HashMap rootProjectDirs = Maps.newHashMap();
        for (ProjectConfiguration rootProjectConfiguration : rootConfigurations.build()) {
            String rootProjectDirPath = rootProjectConfiguration.toRequestAttributes(ProjectConfiguration.ConversionStrategy.IGNORE_WORKSPACE_SETTINGS).getProjectDir().getAbsolutePath();
            if (!rootProjectDirs.containsKey(rootProjectDirPath)) {
                rootProjectDirs.put(rootProjectDirPath, rootProjectConfiguration);
                continue;
            }
            throw new GradlePluginsRuntimeException(String.format("Inconsistent Gradle project configuration for project at %s.", rootProjectDirPath));
        }
        return rootConfigurations.build();
    }

    @Override
    public ImmutableSet<ProjectConfiguration> getAllProjectConfigurations() {
        ImmutableSet.Builder allConfigurations = ImmutableSet.builder();
        for (IProject workspaceProject : this.workspaceOperations.getAllProjects()) {
            Optional<ProjectConfiguration> projectConfiguration;
            if (!GradleProjectNature.isPresentOn(workspaceProject) || !(projectConfiguration = this.tryReadProjectConfiguration(workspaceProject)).isPresent()) continue;
            allConfigurations.add(projectConfiguration.get());
        }
        return allConfigurations.build();
    }

    @Override
    public void saveProjectConfiguration(ProjectConfiguration projectConfiguration, IProject workspaceProject) {
        this.projectConfigurationPersistence.saveProjectConfiguration(projectConfiguration, workspaceProject);
    }

    @Override
    public ProjectConfiguration readProjectConfiguration(IProject workspaceProject) {
        return this.tryReadProjectConfiguration(workspaceProject, false);
    }

    @Override
    public Optional<ProjectConfiguration> tryReadProjectConfiguration(IProject project) {
        ProjectConfiguration configuration = this.tryReadProjectConfiguration(project, true);
        return Optional.fromNullable((Object)configuration);
    }

    private ProjectConfiguration tryReadProjectConfiguration(IProject workspaceProject, boolean suppressErrors) {
        try {
            return this.projectConfigurationPersistence.readProjectConfiguration(workspaceProject);
        }
        catch (RuntimeException e) {
            if (suppressErrors) {
                CorePlugin.logger().warn(String.format("Cannot load project configuration for project %s.", workspaceProject.getName()), e);
                return null;
            }
            throw e;
        }
    }

    @Override
    public void deleteProjectConfiguration(IProject workspaceProject) {
        this.projectConfigurationPersistence.deleteProjectConfiguration(workspaceProject);
    }
}

