/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.gradleware.tooling.toolingmodel.OmniEclipseLinkedResource;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.buildship.core.util.file.RelativePathUtils;
import org.eclipse.buildship.core.workspace.internal.PersistentModelBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

final class DerivedResourcesUpdater {
    private final IProject project;
    private final IProject workspaceProject;
    private final OmniEclipseProject modelProject;

    private DerivedResourcesUpdater(IProject project, OmniEclipseProject modelProject) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.workspaceProject = (IProject)Preconditions.checkNotNull((Object)project);
        this.modelProject = (OmniEclipseProject)Preconditions.checkNotNull((Object)modelProject);
    }

    private void update(PersistentModelBuilder persistentModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            IPath buildDirectoryPath = this.getBuildDirectoryPath();
            List<IPath> derivedResources = this.getDerivedResources(buildDirectoryPath, progress.newChild(1));
            persistentModel.buildDir((IPath)(buildDirectoryPath != null ? buildDirectoryPath : new Path("build")));
            this.removePreviousMarkers(derivedResources, persistentModel, progress.newChild(1));
            this.addNewMarkers(derivedResources, persistentModel, progress.newChild(1));
        }
        catch (CoreException e) {
            String message = String.format("Could not update derived resources on project %s.", this.project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private List<IPath> getDerivedResources(IPath possibleBuildDirectoryPath, SubMonitor progress) {
        ArrayList derivedResources = Lists.newArrayList((Object[])new IPath[]{new Path(".gradle")});
        if (possibleBuildDirectoryPath != null) {
            derivedResources.add(possibleBuildDirectoryPath);
        }
        return derivedResources;
    }

    private void removePreviousMarkers(List<IPath> derivedResources, PersistentModelBuilder persistentModel, SubMonitor progress) throws CoreException {
        PersistentModel previousModel = persistentModel.getPrevious();
        Collection<Object> previouslyKnownDerivedResources = previousModel.isPresent() ? previousModel.getDerivedResources() : Collections.emptyList();
        progress.setWorkRemaining(previouslyKnownDerivedResources.size());
        for (IPath iPath : previouslyKnownDerivedResources) {
            IResource resource = this.project.findMember(iPath);
            if (resource != null) {
                resource.setDerived(false, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            progress.worked(1);
        }
    }

    private void addNewMarkers(List<IPath> derivedResources, PersistentModelBuilder persistentModel, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(derivedResources.size());
        for (IPath resourcePath : derivedResources) {
            IResource resource = this.project.findMember(resourcePath);
            if (resource != null) {
                resource.setDerived(true, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            progress.worked(1);
        }
        persistentModel.derivedResources(derivedResources);
    }

    private IPath getBuildDirectoryPath() {
        OmniGradleProject gradleProject = this.modelProject.getGradleProject();
        Maybe buildDirectory = gradleProject.getBuildDirectory();
        if (buildDirectory.isPresent() && buildDirectory.get() != null) {
            Path buildDirLocation = new Path(((File)buildDirectory.get()).getPath());
            return this.normalizeBuildDirectoryPath(buildDirLocation);
        }
        return new Path("build");
    }

    private IPath normalizeBuildDirectoryPath(Path buildDirLocation) {
        IPath projectLocation = this.workspaceProject.getLocation();
        if (projectLocation.isPrefixOf((IPath)buildDirLocation)) {
            IPath relativePath = RelativePathUtils.getRelativePath(projectLocation, (IPath)buildDirLocation);
            return relativePath;
        }
        for (OmniEclipseLinkedResource linkedResource : this.modelProject.getLinkedResources()) {
            if (!buildDirLocation.toString().equals(linkedResource.getLocation())) continue;
            return new Path(linkedResource.getName());
        }
        return null;
    }

    static void update(IProject workspaceProject, OmniEclipseProject project, PersistentModelBuilder persistentModel, IProgressMonitor monitor) {
        new DerivedResourcesUpdater(workspaceProject, project).update(persistentModel, monitor);
    }
}

