/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import java.io.File;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;

final class EclipseVmUtil {
    private static final String VM_ID_PREFIX = "org.eclipse.buildship.core.vm.";
    private static final String VM_NAME_PREFIX = "Java SE";

    private EclipseVmUtil() {
    }

    public static IVMInstall findOrRegisterVM(File installLocation, String version) {
        Optional<IVMInstall> vm = EclipseVmUtil.findRegisteredVM(installLocation);
        return vm.isPresent() ? (IVMInstall)vm.get() : EclipseVmUtil.registerNewVM(installLocation, version);
    }

    private static Optional<IVMInstall> findRegisteredVM(File installLocation) {
        for (IVMInstallType type : JavaRuntime.getVMInstallTypes()) {
            for (IVMInstall instance : type.getVMInstalls()) {
                File location = instance.getInstallLocation();
                if (location == null || !location.equals(installLocation)) continue;
                return Optional.of((Object)instance);
            }
        }
        return Optional.absent();
    }

    private static IVMInstall registerNewVM(File installLocation, String version) {
        IVMInstallType installType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        String vmId = EclipseVmUtil.generateUniqueVMId(installType);
        String vmName = EclipseVmUtil.generateUniqueVMName(version, installType);
        IVMInstall vm = installType.createVMInstall(vmId);
        vm.setName(vmName);
        vm.setInstallLocation(installLocation);
        JavaRuntime.fireVMAdded((IVMInstall)vm);
        return vm;
    }

    private static String generateUniqueVMId(IVMInstallType installType) {
        int counter = 1;
        String vmId = VM_ID_PREFIX + counter;
        while (installType.findVMInstall(vmId) != null) {
            vmId = VM_ID_PREFIX + ++counter;
        }
        return vmId;
    }

    private static String generateUniqueVMName(String version, IVMInstallType installType) {
        int counter = 1;
        String vmName = "Java SE " + version;
        while (installType.findVMInstallByName(vmName) != null) {
            vmName = "Java SE " + version + " (" + ++counter + ")";
        }
        return vmName;
    }
}

