/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.selection;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IServiceLocator;

public final class ContextActivatingSelectionListener
implements ISelectionListener {
    private final Predicate<? super ISelection> activationPredicate;
    private final String contextId;
    private final IContextService contextService;
    private IContextActivation activation;

    public ContextActivatingSelectionListener(String contextId, Predicate<? super ISelection> activationPredicate, IServiceLocator serviceLocator) {
        this.activationPredicate = (Predicate)Preconditions.checkNotNull(activationPredicate);
        this.contextId = (String)Preconditions.checkNotNull((Object)contextId);
        this.contextService = (IContextService)serviceLocator.getService(IContextService.class);
        this.activation = null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.activationPredicate.apply((Object)selection)) {
            this.activation = this.contextService.activateContext(this.contextId);
        } else {
            this.contextService.deactivateContext(this.activation);
        }
    }
}

