/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.buildship.ui.view.execution.OperationItem;
import org.eclipse.buildship.ui.view.execution.OperationItemRenderer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.events.OperationDescriptor;

public final class UpdateDurationJob
extends Job {
    private final long repeatDelay;
    private final OperationItemRenderer operationItemRenderer;
    private final Map<OperationDescriptor, OperationItem> operationItems;
    private volatile boolean running;

    public UpdateDurationJob(long repeatDelay, OperationItemRenderer operationItemRenderer) {
        super("Updating duration of non-finished operations");
        this.repeatDelay = repeatDelay;
        this.operationItemRenderer = operationItemRenderer;
        this.operationItems = Maps.newHashMap();
        this.running = true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        for (OperationItem operationItem : this.getOperationItems()) {
            this.operationItemRenderer.updateDuration(operationItem);
        }
        this.schedule(this.repeatDelay);
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperationItem(OperationItem operationItem) {
        Preconditions.checkNotNull((Object)operationItem.getStartEvent());
        Map<OperationDescriptor, OperationItem> map = this.operationItems;
        synchronized (map) {
            this.operationItems.put(operationItem.getStartEvent().getDescriptor(), operationItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOperationItem(OperationItem operationItem) {
        Preconditions.checkNotNull((Object)operationItem.getStartEvent());
        Map<OperationDescriptor, OperationItem> map = this.operationItems;
        synchronized (map) {
            this.operationItems.remove(operationItem.getStartEvent().getDescriptor());
            if (this.operationItems.isEmpty()) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OperationItem> getOperationItems() {
        Map<OperationDescriptor, OperationItem> map = this.operationItems;
        synchronized (map) {
            return ImmutableList.copyOf(this.operationItems.values());
        }
    }

    public boolean shouldSchedule() {
        return this.running;
    }

    public void stop() {
        this.running = false;
    }
}

