/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.repository.CompositeBuildModelRepository;
import com.gradleware.tooling.toolingmodel.repository.Environment;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProvider;
import com.gradleware.tooling.toolingmodel.repository.SingleBuildModelRepository;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultCompositeModelRepository;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultSingleBuildModelRepository;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.Factory;

public final class DefaultModelRepositoryProvider
implements ModelRepositoryProvider {
    private final ToolingClient toolingClient;
    private final Environment environment;
    private final Factory<EventBus> eventBusFactory;
    private final Map<FixedRequestAttributes, SingleBuildModelRepository> modelRepositories;
    private final Map<ImmutableSet<FixedRequestAttributes>, CompositeBuildModelRepository> compositeModelRepositories;

    public DefaultModelRepositoryProvider(ToolingClient toolingClient) {
        this(toolingClient, Environment.STANDALONE);
    }

    public DefaultModelRepositoryProvider(ToolingClient toolingClient, Environment environment) {
        this(toolingClient, environment, DefaultEventBusFactory.INSTANCE);
    }

    public DefaultModelRepositoryProvider(ToolingClient toolingClient, Environment environment, Factory<EventBus> eventBusFactory) {
        this.toolingClient = (ToolingClient)Preconditions.checkNotNull((Object)toolingClient);
        this.environment = (Environment)((Object)Preconditions.checkNotNull((Object)((Object)environment)));
        this.eventBusFactory = (Factory)Preconditions.checkNotNull(eventBusFactory);
        this.modelRepositories = Maps.newHashMap();
        this.compositeModelRepositories = Maps.newHashMap();
    }

    @Override
    public SingleBuildModelRepository getModelRepository(FixedRequestAttributes fixedRequestAttributes) {
        Preconditions.checkNotNull((Object)fixedRequestAttributes);
        return this.getOrCreateModelRepository(fixedRequestAttributes);
    }

    @Override
    public CompositeBuildModelRepository getCompositeModelRepository(Set<FixedRequestAttributes> fixedRequestAttributes) {
        return this.getOrCreateCompositeModelRepository((ImmutableSet<FixedRequestAttributes>)ImmutableSet.copyOf(fixedRequestAttributes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleBuildModelRepository getOrCreateModelRepository(FixedRequestAttributes fixedRequestAttributes) {
        SingleBuildModelRepository modelRepository;
        Map<FixedRequestAttributes, SingleBuildModelRepository> map = this.modelRepositories;
        synchronized (map) {
            if (!this.modelRepositories.containsKey(fixedRequestAttributes)) {
                modelRepository = new DefaultSingleBuildModelRepository(fixedRequestAttributes, this.toolingClient, (EventBus)this.eventBusFactory.create(), this.environment);
                this.modelRepositories.put(fixedRequestAttributes, modelRepository);
            } else {
                modelRepository = this.modelRepositories.get(fixedRequestAttributes);
            }
        }
        return modelRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeBuildModelRepository getOrCreateCompositeModelRepository(ImmutableSet<FixedRequestAttributes> fixedRequestAttributes) {
        CompositeBuildModelRepository modelRepository;
        Map<ImmutableSet<FixedRequestAttributes>, CompositeBuildModelRepository> map = this.compositeModelRepositories;
        synchronized (map) {
            if (!this.compositeModelRepositories.containsKey(fixedRequestAttributes)) {
                modelRepository = new DefaultCompositeModelRepository((Set<FixedRequestAttributes>)fixedRequestAttributes, this.toolingClient, (EventBus)this.eventBusFactory.create());
                this.compositeModelRepositories.put(fixedRequestAttributes, modelRepository);
            } else {
                modelRepository = this.compositeModelRepositories.get(fixedRequestAttributes);
            }
        }
        return modelRepository;
    }

    private static enum DefaultEventBusFactory implements Factory<EventBus>
    {
        INSTANCE;


        public EventBus create() {
            return new EventBus();
        }
    }
}

