/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.gradle.GradleDistributionSerializer;
import org.eclipse.buildship.core.util.variable.ExpressionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public final class GradleRunConfigurationAttributes {
    private static final String TASKS = "tasks";
    private static final String WORKING_DIR = "working_dir";
    private static final String GRADLE_DISTRIBUTION = "gradle_distribution";
    private static final String GRADLE_USER_HOME = "gradle_user_home";
    private static final String JAVA_HOME = "java_home";
    private static final String JVM_ARGUMENTS = "jvm_arguments";
    private static final String ARGUMENTS = "arguments";
    private static final String SHOW_EXECUTION_VIEW = "show_execution_view";
    private static final String SHOW_CONSOLE_VIEW = "show_console_view";
    private final ImmutableList<String> tasks;
    private final String workingDirExpression;
    private final GradleDistribution gradleDistribution;
    private final String gradleUserHomeExpression;
    private final String javaHomeExpression;
    private final ImmutableList<String> jvmArgumentExpressions;
    private final ImmutableList<String> argumentExpressions;
    private final boolean showExecutionView;
    private final boolean showConsoleView;

    private GradleRunConfigurationAttributes(List<String> tasks, String workingDirExpression, GradleDistribution gradleDistribution, String gradleUserHomeExpression, String javaHomeExpression, List<String> jvmArgumentExpressions, List<String> argumentExpressions, boolean showExecutionView, boolean showConsoleView) {
        this.tasks = ImmutableList.copyOf(tasks);
        this.workingDirExpression = (String)Preconditions.checkNotNull((Object)workingDirExpression);
        this.gradleDistribution = (GradleDistribution)Preconditions.checkNotNull((Object)gradleDistribution);
        this.gradleUserHomeExpression = gradleUserHomeExpression;
        this.javaHomeExpression = javaHomeExpression;
        this.jvmArgumentExpressions = ImmutableList.copyOf(jvmArgumentExpressions);
        this.argumentExpressions = ImmutableList.copyOf(argumentExpressions);
        this.showExecutionView = showExecutionView;
        this.showConsoleView = showConsoleView;
    }

    public ImmutableList<String> getTasks() {
        return this.tasks;
    }

    public String getWorkingDirExpression() {
        return this.workingDirExpression;
    }

    public File getWorkingDir() {
        try {
            String location = ExpressionUtils.decode(this.workingDirExpression);
            return new File(location).getAbsoluteFile();
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot resolve working directory expression %s.", this.workingDirExpression));
        }
    }

    public GradleDistribution getGradleDistribution() {
        return this.gradleDistribution;
    }

    public String getGradleUserHomeExpression() {
        return this.gradleUserHomeExpression;
    }

    public File getGradleUserHome() {
        try {
            String location = ExpressionUtils.decode(this.gradleUserHomeExpression);
            return (File)FileUtils.getAbsoluteFile(location).orNull();
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot resolve Gradle user home directory expression %s.", this.gradleUserHomeExpression));
        }
    }

    public String getJavaHomeExpression() {
        return this.javaHomeExpression;
    }

    public File getJavaHome() {
        try {
            String location = ExpressionUtils.decode(this.javaHomeExpression);
            return (File)FileUtils.getAbsoluteFile(location).orNull();
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot resolve Java home directory expression %s.", this.javaHomeExpression));
        }
    }

    public ImmutableList<String> getJvmArgumentExpressions() {
        return this.jvmArgumentExpressions;
    }

    public ImmutableList<String> getJvmArguments() {
        return FluentIterable.from(this.jvmArgumentExpressions).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                try {
                    return ExpressionUtils.decode(input);
                }
                catch (CoreException e) {
                    throw new GradlePluginsRuntimeException(String.format("Cannot resolve JVM argument expression %s.", input));
                }
            }
        }).toList();
    }

    public ImmutableList<String> getArgumentExpressions() {
        return this.argumentExpressions;
    }

    public ImmutableList<String> getArguments() {
        return FluentIterable.from(this.argumentExpressions).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                try {
                    return ExpressionUtils.decode(input);
                }
                catch (CoreException e) {
                    throw new GradlePluginsRuntimeException(String.format("Cannot resolve argument expression %s.", input));
                }
            }
        }).toList();
    }

    public boolean isShowExecutionView() {
        return this.showExecutionView;
    }

    public boolean isShowConsoleView() {
        return this.showConsoleView;
    }

    public boolean hasSameUniqueAttributes(ILaunchConfiguration launchConfiguration) {
        try {
            return this.tasks.equals((Object)launchConfiguration.getAttribute(TASKS, (List)ImmutableList.of())) && this.workingDirExpression.equals(launchConfiguration.getAttribute(WORKING_DIR, ""));
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read Gradle launch configuration %s.", launchConfiguration), e);
        }
    }

    public FixedRequestAttributes toFixedRequestAttributes() {
        File workingDir = this.getWorkingDir();
        File gradleUserHome = this.getGradleUserHome();
        GradleDistribution gradleDistribution = this.getGradleDistribution();
        File javaHome = this.getJavaHome();
        ImmutableList<String> jvmArguments = this.getJvmArguments();
        ImmutableList<String> arguments = this.getArguments();
        return new FixedRequestAttributes(workingDir, gradleUserHome, gradleDistribution, javaHome, jvmArguments, arguments);
    }

    public void apply(ILaunchConfigurationWorkingCopy launchConfiguration) {
        GradleRunConfigurationAttributes.applyTasks(this.tasks, launchConfiguration);
        GradleRunConfigurationAttributes.applyWorkingDirExpression(this.workingDirExpression, launchConfiguration);
        GradleRunConfigurationAttributes.applyGradleDistribution(this.gradleDistribution, launchConfiguration);
        GradleRunConfigurationAttributes.applyGradleUserHomeExpression(this.gradleUserHomeExpression, launchConfiguration);
        GradleRunConfigurationAttributes.applyJavaHomeExpression(this.javaHomeExpression, launchConfiguration);
        GradleRunConfigurationAttributes.applyJvmArgumentExpressions(this.jvmArgumentExpressions, launchConfiguration);
        GradleRunConfigurationAttributes.applyArgumentExpressions(this.argumentExpressions, launchConfiguration);
        GradleRunConfigurationAttributes.applyShowExecutionView(this.showExecutionView, launchConfiguration);
        GradleRunConfigurationAttributes.applyShowConsoleView(this.showConsoleView, launchConfiguration);
    }

    public static void applyTasks(List<String> tasks, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(TASKS, tasks);
    }

    public static void applyWorkingDirExpression(String workingDirExpression, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(WORKING_DIR, (String)Preconditions.checkNotNull((Object)workingDirExpression));
    }

    public static void applyGradleDistribution(GradleDistribution gradleDistribution, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(GRADLE_DISTRIBUTION, (String)Preconditions.checkNotNull((Object)GradleDistributionSerializer.INSTANCE.serializeToString(gradleDistribution)));
    }

    public static void applyGradleUserHomeExpression(String gradleUserHomeExpression, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(GRADLE_USER_HOME, gradleUserHomeExpression);
    }

    public static void applyJavaHomeExpression(String javaHomeExpression, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(JAVA_HOME, javaHomeExpression);
    }

    public static void applyJvmArgumentExpressions(List<String> jvmArgumentsExpression, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(JVM_ARGUMENTS, jvmArgumentsExpression);
    }

    public static void applyArgumentExpressions(List<String> argumentsExpression, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(ARGUMENTS, argumentsExpression);
    }

    public static void applyShowExecutionView(boolean showExecutionView, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(SHOW_EXECUTION_VIEW, showExecutionView);
    }

    public static void applyShowConsoleView(boolean showConsoleView, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(SHOW_CONSOLE_VIEW, showConsoleView);
    }

    public static GradleRunConfigurationAttributes with(List<String> tasks, String workingDirExpression, GradleDistribution gradleDistribution, String gradleUserHomeExpression, String javaHomeExpression, List<String> jvmArgumentExpressions, List<String> argumentExpressions, boolean showExecutionView, boolean showConsoleView) {
        return new GradleRunConfigurationAttributes(tasks, workingDirExpression, gradleDistribution, gradleUserHomeExpression, javaHomeExpression, jvmArgumentExpressions, argumentExpressions, showExecutionView, showConsoleView);
    }

    public static GradleRunConfigurationAttributes from(ILaunchConfiguration launchConfiguration) {
        boolean showConsoleView;
        boolean showExecutionView;
        List argumentExpressions;
        List jvmArgumentExpressions;
        String javaHomeExpression;
        String gradleUserHomeExpression;
        GradleDistribution gradleDistribution;
        String workingDirExpression;
        List tasks;
        Preconditions.checkNotNull((Object)launchConfiguration);
        try {
            tasks = launchConfiguration.getAttribute(TASKS, (List)ImmutableList.of());
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", TASKS));
        }
        try {
            workingDirExpression = launchConfiguration.getAttribute(WORKING_DIR, "");
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", WORKING_DIR));
        }
        try {
            String serialized = launchConfiguration.getAttribute(GRADLE_DISTRIBUTION, (String)null);
            gradleDistribution = serialized != null ? GradleDistributionSerializer.INSTANCE.deserializeFromString(serialized) : GradleDistribution.fromBuild();
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", GRADLE_DISTRIBUTION));
        }
        try {
            gradleUserHomeExpression = launchConfiguration.getAttribute(GRADLE_USER_HOME, (String)null);
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", GRADLE_USER_HOME));
        }
        try {
            javaHomeExpression = launchConfiguration.getAttribute(JAVA_HOME, (String)null);
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", JAVA_HOME));
        }
        try {
            jvmArgumentExpressions = launchConfiguration.getAttribute(JVM_ARGUMENTS, (List)ImmutableList.of());
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", JVM_ARGUMENTS));
        }
        try {
            argumentExpressions = launchConfiguration.getAttribute(ARGUMENTS, (List)ImmutableList.of());
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", ARGUMENTS));
        }
        try {
            showExecutionView = launchConfiguration.getAttribute(SHOW_EXECUTION_VIEW, true);
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", SHOW_EXECUTION_VIEW));
        }
        try {
            showConsoleView = launchConfiguration.getAttribute(SHOW_CONSOLE_VIEW, true);
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", SHOW_CONSOLE_VIEW));
        }
        return GradleRunConfigurationAttributes.with(tasks, workingDirExpression, gradleDistribution, gradleUserHomeExpression, javaHomeExpression, jvmArgumentExpressions, argumentExpressions, showExecutionView, showConsoleView);
    }
}

