/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.composite.GradleDistributionAware;

public final class GradleDistribution {
    private final File localInstallationDir;
    private final URI remoteDistributionUri;
    private final String version;

    private GradleDistribution(File localInstallationDir, URI remoteDistributionUri, String version) {
        this.localInstallationDir = localInstallationDir;
        this.remoteDistributionUri = remoteDistributionUri;
        this.version = version;
        this.checkNoMoreThanOneAttributeSet(localInstallationDir, remoteDistributionUri, version);
    }

    private void checkNoMoreThanOneAttributeSet(File localInstallationDir, URI remoteDistributionUri, String version) {
        int count = 0;
        List<Object> items = Arrays.asList(localInstallationDir, remoteDistributionUri, version);
        for (Object item : items) {
            if (item == null) continue;
            ++count;
        }
        Preconditions.checkArgument((count <= 1 ? 1 : 0) != 0, (Object)"Attributes of more than one distribution type specified.");
    }

    public void apply(GradleConnector connector) {
        Preconditions.checkNotNull((Object)connector);
        if (this.localInstallationDir != null) {
            connector.useInstallation(this.localInstallationDir);
        } else if (this.remoteDistributionUri != null) {
            connector.useDistribution(this.remoteDistributionUri);
        } else if (this.version != null) {
            connector.useGradleVersion(this.version);
        } else {
            connector.useBuildDistribution();
        }
    }

    public void apply(GradleDistributionAware target) {
        Preconditions.checkNotNull((Object)target);
        if (this.localInstallationDir != null) {
            target.useInstallation(this.localInstallationDir);
        } else if (this.remoteDistributionUri != null) {
            target.useDistribution(this.remoteDistributionUri);
        } else if (this.version != null) {
            target.useGradleVersion(this.version);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GradleDistribution that = (GradleDistribution)other;
        return Objects.equal((Object)this.localInstallationDir, (Object)that.localInstallationDir) && Objects.equal((Object)this.remoteDistributionUri, (Object)that.remoteDistributionUri) && Objects.equal((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.localInstallationDir, this.remoteDistributionUri, this.version});
    }

    public String toString() {
        if (this.localInstallationDir != null) {
            return String.format("Gradle installation %s", this.localInstallationDir.getAbsolutePath());
        }
        if (this.remoteDistributionUri != null) {
            return String.format("Gradle distribution %s", this.remoteDistributionUri);
        }
        if (this.version != null) {
            return String.format("Gradle version %s", this.version);
        }
        return "Gradle version of target build";
    }

    public static GradleDistribution forLocalInstallation(File installationDir) {
        Preconditions.checkNotNull((Object)installationDir);
        return new GradleDistribution(installationDir, null, null);
    }

    public static GradleDistribution forRemoteDistribution(URI distributionUri) {
        Preconditions.checkNotNull((Object)distributionUri);
        return new GradleDistribution(null, distributionUri, null);
    }

    public static GradleDistribution forVersion(String version) {
        Preconditions.checkNotNull((Object)version);
        return new GradleDistribution(null, null, version);
    }

    public static GradleDistribution fromBuild() {
        return new GradleDistribution(null, null, null);
    }
}

