/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.progress;

import java.util.concurrent.TimeUnit;
import org.eclipse.buildship.core.util.progress.RateLimitingProgressMonitor;
import org.eclipse.buildship.core.util.progress.ToolingApiCommand;
import org.eclipse.buildship.core.util.progress.ToolingApiInvoker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;

public abstract class ToolingApiJob
extends Job {
    private final CancellationTokenSource tokenSource = GradleConnector.newCancellationTokenSource();
    private final String workName;
    private final boolean notifyUserAboutBuildFailures;

    protected ToolingApiJob(String name) {
        this(name, true);
    }

    protected ToolingApiJob(String name, boolean notifyUserAboutBuildFailures) {
        super(name);
        this.workName = name;
        this.notifyUserAboutBuildFailures = notifyUserAboutBuildFailures;
    }

    protected CancellationToken getToken() {
        return this.tokenSource.token();
    }

    public final IStatus run(IProgressMonitor monitor) {
        ToolingApiInvoker invoker = new ToolingApiInvoker(this.workName, this.notifyUserAboutBuildFailures);
        RateLimitingProgressMonitor efficientMonitor = new RateLimitingProgressMonitor(monitor, 500L, TimeUnit.MILLISECONDS);
        return invoker.invoke(new ToolingApiCommand((IProgressMonitor)efficientMonitor){
            final /* synthetic */ IProgressMonitor val$efficientMonitor;
            {
                this.val$efficientMonitor = iProgressMonitor;
            }

            @Override
            public void run() throws Exception {
                ToolingApiJob.this.runToolingApiJob(this.val$efficientMonitor);
            }
        }, (IProgressMonitor)efficientMonitor);
    }

    protected abstract void runToolingApiJob(IProgressMonitor var1) throws Exception;

    protected void canceling() {
        this.tokenSource.cancel();
    }

    public boolean belongsTo(Object family) {
        return "org.eclipse.buildship.core.jobs".equals(family);
    }
}

