/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.progress;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;

public final class RateLimitingProgressMonitor
extends ProgressMonitorWrapper {
    private final Timer timer = new Timer();
    private final AtomicReference<String> lastTask = new AtomicReference();
    private final long rate;
    private final TimeUnit rateUnit;

    public RateLimitingProgressMonitor(IProgressMonitor monitor, long rate, TimeUnit rateUnit) {
        super(monitor);
        this.rate = rate;
        this.rateUnit = rateUnit;
    }

    public void beginTask(String name, int totalWork) {
        this.timer.scheduleAtFixedRate(this.forwardMostRecentMessage(), 0L, this.rateUnit.toMillis(this.rate));
        super.beginTask(name, totalWork);
    }

    public void subTask(String name) {
        this.lastTask.set(name);
    }

    public void done() {
        this.timer.cancel();
        super.done();
    }

    private TimerTask forwardMostRecentMessage() {
        return new TimerTask(){

            @Override
            public void run() {
                String taskName = RateLimitingProgressMonitor.this.lastTask.getAndSet(null);
                if (taskName != null) {
                    RateLimitingProgressMonitor.super.subTask(taskName);
                }
            }
        };
    }
}

