/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.projectimport;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniGradleBuildStructure;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.SimpleModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import com.gradleware.tooling.toolingmodel.util.Pair;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.gradle.tooling.ProgressListener;

public final class ProjectPreviewJob
extends ToolingApiWorkspaceJob {
    private final FixedRequestAttributes fixedAttributes;
    private final TransientRequestAttributes transientAttributes;
    private final AsyncHandler initializer;
    private Pair<OmniBuildEnvironment, OmniGradleBuildStructure> result;

    public ProjectPreviewJob(ProjectImportConfiguration configuration, List<ProgressListener> listeners, AsyncHandler initializer, final FutureCallback<Pair<OmniBuildEnvironment, OmniGradleBuildStructure>> resultHandler) {
        super("Loading Gradle project preview");
        this.fixedAttributes = configuration.toFixedAttributes();
        ProcessStreams stream = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
        this.transientAttributes = new TransientRequestAttributes(false, stream.getOutput(), stream.getError(), null, listeners, (List)ImmutableList.of(), this.getToken());
        this.initializer = (AsyncHandler)Preconditions.checkNotNull((Object)initializer);
        this.result = null;
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    resultHandler.onSuccess((Object)ProjectPreviewJob.this.result);
                } else {
                    resultHandler.onFailure(event.getResult().getException());
                }
            }
        });
    }

    @Override
    protected void runToolingApiJobInWorkspace(IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Load Gradle project preview", 20);
        this.initializer.run((IProgressMonitor)new SubProgressMonitor(monitor, 10), this.getToken());
        OmniBuildEnvironment buildEnvironment = this.fetchBuildEnvironment((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        OmniGradleBuildStructure gradleBuildStructure = this.fetchGradleBuildStructure((IProgressMonitor)new SubProgressMonitor(monitor, 8));
        this.result = new Pair((Object)buildEnvironment, (Object)gradleBuildStructure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OmniBuildEnvironment fetchBuildEnvironment(IProgressMonitor monitor) {
        monitor.beginTask("Load Gradle Build Environment", -1);
        try {
            SimpleModelRepository repository = CorePlugin.modelRepositoryProvider().getModelRepository(this.fixedAttributes);
            OmniBuildEnvironment omniBuildEnvironment = repository.fetchBuildEnvironment(this.transientAttributes, FetchStrategy.FORCE_RELOAD);
            return omniBuildEnvironment;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OmniGradleBuildStructure fetchGradleBuildStructure(IProgressMonitor monitor) {
        monitor.beginTask("Load Gradle Project Structure", -1);
        try {
            SimpleModelRepository repository = CorePlugin.modelRepositoryProvider().getModelRepository(this.fixedAttributes);
            OmniGradleBuildStructure omniGradleBuildStructure = repository.fetchGradleBuildStructure(this.transientAttributes, FetchStrategy.FORCE_RELOAD);
            return omniGradleBuildStructure;
        }
        finally {
            monitor.done();
        }
    }
}

