/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.ui.internal.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.internal.util.nodeselection.NodeSelectionProvider;
import org.eclipse.buildship.ui.internal.util.nodeselection.SelectionSpecificAction;
import org.eclipse.buildship.ui.internal.view.execution.ExecutionViewMessages;
import org.eclipse.buildship.ui.internal.view.execution.FailureDialog;
import org.eclipse.buildship.ui.internal.view.execution.OperationItem;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;

public final class ShowFailureAction
extends Action
implements SelectionSpecificAction {
    private final NodeSelectionProvider selectionProvider;

    public ShowFailureAction(NodeSelectionProvider selectionProvider) {
        super(ExecutionViewMessages.Action_ShowFailure_Text);
        this.selectionProvider = (NodeSelectionProvider)Preconditions.checkNotNull((Object)selectionProvider);
    }

    public void run() {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        List<FinishEvent> failureEvents = this.collectEventsWithFailure(this.selectionProvider.getSelection());
        new FailureDialog(shell, ExecutionViewMessages.Dialog_Failure_Title, failureEvents).open();
    }

    private List<FinishEvent> collectEventsWithFailure(NodeSelection selection) {
        if (selection.isEmpty()) {
            return ImmutableList.of();
        }
        if (!selection.hasAllNodesOfType(OperationItem.class)) {
            return ImmutableList.of();
        }
        ArrayList result = Lists.newArrayList();
        ImmutableList<OperationItem> operationItems = selection.toList(OperationItem.class);
        for (OperationItem operationItem : operationItems) {
            FinishEvent finishEvent = operationItem.getFinishEvent();
            if (finishEvent == null || !(finishEvent.getResult() instanceof FailureResult)) continue;
            result.add(finishEvent);
        }
        return result;
    }

    @Override
    public boolean isVisibleFor(NodeSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        if (!selection.hasAllNodesOfType(OperationItem.class)) {
            return false;
        }
        ImmutableList<OperationItem> operationItems = selection.toList(OperationItem.class);
        return FluentIterable.from(operationItems).anyMatch((Predicate)new Predicate<OperationItem>(this){

            public boolean apply(OperationItem operationItem) {
                FinishEvent finishEvent = operationItem.getFinishEvent();
                return finishEvent != null && finishEvent.getResult() instanceof FailureResult;
            }
        });
    }

    @Override
    public boolean isEnabledFor(NodeSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        if (!selection.hasAllNodesOfType(OperationItem.class)) {
            return false;
        }
        ImmutableList<OperationItem> operationItems = selection.toList(OperationItem.class);
        return FluentIterable.from(operationItems).allMatch((Predicate)new Predicate<OperationItem>(this){

            public boolean apply(OperationItem operationItem) {
                FinishEvent finishEvent = operationItem.getFinishEvent();
                return finishEvent != null && finishEvent.getResult() instanceof FailureResult;
            }
        });
    }

    @Override
    public void setEnabledFor(NodeSelection selection) {
        this.setEnabled(this.isEnabledFor(selection));
    }
}

