/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.CommandLineParser;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;

public abstract class AbstractBuildOption<T, V extends CommandLineOptionConfiguration>
implements BuildOption<T> {
    protected final String property;
    protected final List<V> commandLineOptionConfigurations;
    protected final String deprecatedProperty;

    public AbstractBuildOption(String property) {
        this(property, (String)null, Collections.emptyList());
    }

    public AbstractBuildOption(String property, String deprecatedProperty, V ... commandLineOptionConfiguration) {
        this(property, deprecatedProperty, commandLineOptionConfiguration != null ? Arrays.asList(commandLineOptionConfiguration) : Collections.emptyList());
    }

    public AbstractBuildOption(String property, V ... commandLineOptionConfiguration) {
        this(property, (String)null, commandLineOptionConfiguration != null ? Arrays.asList(commandLineOptionConfiguration) : Collections.emptyList());
    }

    private AbstractBuildOption(String property, String deprecatedProperty, List<V> commandLineOptionConfigurations) {
        this.property = property;
        this.deprecatedProperty = deprecatedProperty;
        this.commandLineOptionConfigurations = commandLineOptionConfigurations;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public String getDeprecatedProperty() {
        return this.deprecatedProperty;
    }

    protected boolean isTrue(String value) {
        return value != null && value.trim().equalsIgnoreCase("true");
    }

    protected CommandLineOption configureCommandLineOption(CommandLineParser parser, String[] options, String description, boolean deprecated, boolean incubating) {
        CommandLineOption option = parser.option(options).hasDescription(description);
        if (deprecated) {
            option.deprecated();
        }
        if (incubating) {
            option.incubating();
        }
        return option;
    }

    protected OptionValue<String> getFromProperties(Map<String, String> properties) {
        String value = properties.get(this.property);
        if (value != null) {
            return new OptionValue<String>(value, Origin.forGradleProperty(this.property));
        }
        if (this.deprecatedProperty != null && (value = properties.get(this.deprecatedProperty)) != null) {
            return new OptionValue<String>(value, Origin.forGradleProperty(this.deprecatedProperty));
        }
        return new OptionValue<Object>(null, null);
    }

    protected static class OptionValue<T> {
        private final T value;
        private final Origin origin;

        public OptionValue(T value, Origin origin) {
            this.value = value;
            this.origin = origin;
        }

        public T getValue() {
            return this.value;
        }

        public Origin getOrigin() {
            return this.origin;
        }
    }
}

