/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.model.internal.Exceptions;

public class PluginClasspathInjectionSupportedCheckModelProducer
implements ModelProducer {
    private final ModelProducer delegate;
    private final VersionDetails versionDetails;

    public PluginClasspathInjectionSupportedCheckModelProducer(ModelProducer delegate, VersionDetails versionDetails) {
        this.versionDetails = versionDetails;
        this.delegate = delegate;
    }

    @Override
    public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
        if (!operationParameters.getInjectedPluginClasspath().isEmpty() && !this.isSupported()) {
            throw Exceptions.unsupportedFeature("plugin classpath injection feature", this.versionDetails.getVersion(), "2.8");
        }
        return this.delegate.produceModel(type, operationParameters);
    }

    private boolean isSupported() {
        return this.versionDetails.supportsPluginClasspathInjection();
    }
}

