/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.execution;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.buildship.ui.internal.util.widget.FilteredTree;
import org.eclipse.buildship.ui.internal.view.execution.ExecutionPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.gradle.tooling.events.ProgressEvent;

public final class UpdateExecutionPageJob
extends Job {
    private static final double MAX_UPDATES_PER_SECOND = 10.0;
    private final ExecutionPage page;
    private final BlockingQueue<ProgressEvent> queue = new LinkedBlockingQueue<ProgressEvent>();
    private volatile boolean running;

    public UpdateExecutionPageJob(ExecutionPage page) {
        super("Updating duration of non-finished operations");
        this.page = page;
        this.running = true;
        this.setSystem(true);
    }

    public void addEvent(ProgressEvent event) {
        this.queue.add(event);
    }

    protected IStatus run(IProgressMonitor monitor) {
        RateLimiter rateLimiter = RateLimiter.create((double)10.0);
        while (this.running || !this.queue.isEmpty()) {
            rateLimiter.acquire();
            ArrayList events = Lists.newArrayList();
            this.queue.drainTo(events);
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display.isDisposed()) continue;
            display.syncExec((Runnable)new UpdateExecutionPageContent(this.page, events));
        }
        return Status.OK_STATUS;
    }

    public void stop() {
        this.running = false;
    }

    private static class UpdateExecutionPageContent
    implements Runnable {
        private final ExecutionPage page;
        private final List<ProgressEvent> events;

        public UpdateExecutionPageContent(ExecutionPage page, List<ProgressEvent> events) {
            this.page = page;
            this.events = events;
        }

        @Override
        public void run() {
            if (!((FilteredTree)((Object)this.page.getPageControl())).isDisposed()) {
                for (ProgressEvent event : this.events) {
                    this.page.onProgress(event);
                }
                this.page.refreshChangedItems();
            }
        }
    }
}

