/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.DefaultModelProvider;
import org.eclipse.buildship.core.workspace.internal.SynchronizeGradleBuildsJob;

public class DefaultGradleBuild
implements GradleBuild {
    private final FixedRequestAttributes attributes;

    public DefaultGradleBuild(FixedRequestAttributes builds) {
        this.attributes = (FixedRequestAttributes)Preconditions.checkNotNull((Object)builds);
    }

    @Override
    public void synchronize() {
        this.synchronize(NewProjectHandler.NO_OP);
    }

    @Override
    public void synchronize(NewProjectHandler newProjectHandler) {
        this.synchronize(newProjectHandler, AsyncHandler.NO_OP);
    }

    @Override
    public void synchronize(NewProjectHandler newProjectHandler, AsyncHandler initializer) {
        SynchronizeGradleBuildsJob.forSingleGradleBuild(this, newProjectHandler, initializer).schedule();
    }

    @Override
    public ModelProvider getModelProvider() {
        ModelRepository modelRepository = CorePlugin.modelRepositoryProvider().getModelRepository(this.attributes);
        return new DefaultModelProvider(modelRepository);
    }

    @Override
    public FixedRequestAttributes getRequestAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultGradleBuild) {
            DefaultGradleBuild other = (DefaultGradleBuild)obj;
            return Objects.equal((Object)this.attributes, (Object)other.attributes);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attributes});
    }
}

