/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace;

import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.gradle.tooling.CancellationToken;

public final class SynchronizeJavaWorkspaceProjectJob
extends ToolingApiWorkspaceJob {
    private final IJavaProject project;

    public SynchronizeJavaWorkspaceProjectJob(IJavaProject project) {
        super(String.format("Synchronize Java workspace project %s", project.getProject().getName()), false);
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runToolingApiJobInWorkspace(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(String.format("Synchronizing Java workspace project %s", this.project.getProject().getName()), 100);
        IJobManager manager = Job.getJobManager();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        manager.beginRule((ISchedulingRule)workspaceRoot, monitor);
        try {
            this.synchronizeWorkspaceProject(this.project, monitor, this.getToken());
        }
        finally {
            manager.endRule((ISchedulingRule)workspaceRoot);
        }
    }

    private void synchronizeWorkspaceProject(IJavaProject javaProject, IProgressMonitor monitor, CancellationToken token) throws CoreException {
        FixedRequestAttributes rootRequestAttributes = null;
        OmniEclipseGradleBuild gradleBuild = null;
        IProject project = javaProject.getProject();
        if (GradleProjectNature.INSTANCE.isPresentOn(project)) {
            ProjectConfiguration configuration = CorePlugin.projectConfigurationManager().readProjectConfiguration(project);
            rootRequestAttributes = configuration.getRequestAttributes();
            gradleBuild = this.fetchEclipseGradleBuild(rootRequestAttributes, monitor, token);
        }
        CorePlugin.workspaceGradleOperations().synchronizeWorkspaceProject(project, gradleBuild, rootRequestAttributes, monitor);
    }

    private OmniEclipseGradleBuild fetchEclipseGradleBuild(FixedRequestAttributes fixedRequestAttributes, IProgressMonitor monitor, CancellationToken token) {
        ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
        ImmutableList progressListeners = ImmutableList.of((Object)new DelegatingProgressListener(monitor));
        TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), null, (List)progressListeners, (List)ImmutableList.of(), token);
        ModelRepository repository = CorePlugin.modelRepositoryProvider().getModelRepository(fixedRequestAttributes);
        return repository.fetchEclipseGradleBuild(transientAttributes, FetchStrategy.LOAD_IF_NOT_CACHED);
    }
}

