/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.console;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.console.ConsoleMessages;
import org.eclipse.buildship.ui.console.GradleConsole;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public final class RemoveAllTerminatedGradleConsolesAction
extends Action {
    private final GradleConsole gradleConsole;

    public RemoveAllTerminatedGradleConsolesAction(GradleConsole gradleConsole) {
        this.gradleConsole = (GradleConsole)((Object)Preconditions.checkNotNull((Object)((Object)gradleConsole)));
        this.setToolTipText(ConsoleMessages.Action_RemoveAllTerminatedConsoles_Tooltip);
        this.setImageDescriptor(PluginImages.REMOVE_ALL_CONSOLES.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.REMOVE_ALL_CONSOLES.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.registerJobChangeListener();
    }

    private void registerJobChangeListener() {
        Optional<ProcessDescription> processDescription = this.gradleConsole.getProcessDescription();
        if (processDescription.isPresent()) {
            Job job = ((ProcessDescription)processDescription.get()).getJob();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    RemoveAllTerminatedGradleConsolesAction.this.update();
                }
            });
            this.update();
        } else {
            this.setEnabled(false);
        }
    }

    private void update() {
        this.setEnabled(this.gradleConsole.isCloseable() && this.gradleConsole.isTerminated());
    }

    public void run() {
        ImmutableList<GradleConsole> terminatedConsoles = this.getTerminatedConsoles();
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles((IConsole[])terminatedConsoles.toArray((Object[])new GradleConsole[terminatedConsoles.size()]));
    }

    private ImmutableList<GradleConsole> getTerminatedConsoles() {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        return FluentIterable.from(Arrays.asList(consoleManager.getConsoles())).filter(GradleConsole.class).filter((Predicate)new Predicate<GradleConsole>(){

            public boolean apply(GradleConsole console) {
                return console.isCloseable() && console.isTerminated();
            }
        }).toList();
    }

    public void dispose() {
    }
}

